/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.context;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.util.MimeTypes;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public final class ServletContextImpl
implements ExtServletContext {
    private final Bundle bundle;
    private final ServletContext context;
    private final HttpContext httpContext;
    private final Map<String, Object> attributes;
    private final ServletContextAttributeListener attributeListener;

    public ServletContextImpl(Bundle bundle, ServletContext context, HttpContext httpContext, ServletContextAttributeListener attributeListener, boolean sharedAttributes) {
        this.bundle = bundle;
        this.context = context;
        this.httpContext = httpContext;
        this.attributeListener = attributeListener;
        this.attributes = sharedAttributes ? null : new ConcurrentHashMap();
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public ServletContext getContext(String uri) {
        return this.context.getContext(uri);
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return 0;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public Set getResourcePaths(String path) {
        Enumeration paths = this.bundle.getEntryPaths(this.normalizePath(path));
        if (paths == null || !paths.hasMoreElements()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        while (paths.hasMoreElements()) {
            set.add((String)paths.nextElement());
        }
        return set;
    }

    public URL getResource(String path) {
        return this.httpContext.getResource(this.normalizePath(path));
    }

    public InputStream getResourceAsStream(String path) {
        URL res = this.getResource(path);
        if (res != null) {
            try {
                return res.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        String normalizedPath = path.trim().replaceAll("/+", "/");
        if (normalizedPath.startsWith("/") && normalizedPath.length() > 1) {
            normalizedPath = normalizedPath.substring(1);
        }
        return normalizedPath;
    }

    public RequestDispatcher getRequestDispatcher(String uri) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    public boolean setInitParameter(String s, String s2) {
        return false;
    }

    public Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : this.context.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes != null ? Collections.enumeration(this.attributes.keySet()) : this.context.getAttributeNames();
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else if (name != null) {
            Object oldValue;
            if (this.attributes != null) {
                oldValue = this.attributes.put(name, value);
            } else {
                oldValue = this.context.getAttribute(name);
                this.context.setAttribute(name, value);
            }
            if (oldValue == null) {
                this.attributeListener.attributeAdded(new ServletContextAttributeEvent((ServletContext)this, name, value));
            } else {
                this.attributeListener.attributeReplaced(new ServletContextAttributeEvent((ServletContext)this, name, oldValue));
            }
        }
    }

    public void removeAttribute(String name) {
        Object oldValue;
        if (this.attributes != null) {
            oldValue = this.attributes.remove(name);
        } else {
            oldValue = this.context.getAttribute(name);
            this.context.removeAttribute(name);
        }
        if (oldValue != null) {
            this.attributeListener.attributeRemoved(new ServletContextAttributeEvent((ServletContext)this, name, oldValue));
        }
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public Enumeration getServlets() {
        return Collections.enumeration(Collections.emptyList());
    }

    public Enumeration getServletNames() {
        return Collections.enumeration(Collections.emptyList());
    }

    public void log(String message) {
        SystemLogger.info(message);
    }

    public void log(Exception cause, String message) {
        SystemLogger.error(message, cause);
    }

    public void log(String message, Throwable cause) {
        SystemLogger.error(message, cause);
    }

    public String getServletContextName() {
        return this.context.getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String s, String s2) {
        return this.context.addServlet(s, s2);
    }

    public ServletRegistration.Dynamic addServlet(String s, Servlet servlet) {
        return this.context.addServlet(s, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String s, Class<? extends Servlet> aClass) {
        return this.context.addServlet(s, aClass);
    }

    public <T extends Servlet> T createServlet(Class<T> tClass) throws ServletException {
        return (T)this.context.createServlet(tClass);
    }

    public ServletRegistration getServletRegistration(String s) {
        return this.context.getServletRegistration(s);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.context.getServletRegistrations();
    }

    public FilterRegistration.Dynamic addFilter(String s, String s2) {
        return this.context.addFilter(s, s2);
    }

    public FilterRegistration.Dynamic addFilter(String s, Filter filter) {
        return this.context.addFilter(s, filter);
    }

    public FilterRegistration.Dynamic addFilter(String s, Class<? extends Filter> aClass) {
        return this.context.addFilter(s, aClass);
    }

    public <T extends Filter> T createFilter(Class<T> tClass) throws ServletException {
        return (T)this.context.createFilter(tClass);
    }

    public FilterRegistration getFilterRegistration(String s) {
        return this.context.getFilterRegistration(s);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.context.getFilterRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.context.getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.context.setSessionTrackingModes(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.context.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.context.getEffectiveSessionTrackingModes();
    }

    public void addListener(String s) {
        this.context.addListener(s);
    }

    public <T extends EventListener> void addListener(T t) {
        this.context.addListener(t);
    }

    public void addListener(Class<? extends EventListener> aClass) {
        this.context.addListener(aClass);
    }

    public <T extends EventListener> T createListener(Class<T> tClass) throws ServletException {
        return (T)this.context.createListener(tClass);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.context.getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    public void declareRoles(String ... strings) {
        this.context.declareRoles(strings);
    }

    public String getRealPath(String name) {
        return null;
    }

    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    public String getMimeType(String file) {
        String type = this.httpContext.getMimeType(file);
        if (type != null) {
            return type;
        }
        return MimeTypes.get().getByFile(file);
    }

    @Override
    public boolean handleSecurity(HttpServletRequest req, HttpServletResponse res) throws IOException {
        return this.httpContext.handleSecurity(req, res);
    }
}

