/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.commands;

import java.lang.reflect.Field;
import org.apache.felix.http.base.internal.handler.HandlerRegistry;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.service.HttpServiceImpl;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.ShellTable;
import org.osgi.service.http.HttpService;

@Command(scope="jahia", name="servlets", description="List registered servlets in OSGi Http service")
@Service
public class ServletListCommand
implements Action {
    @Reference
    private HttpService httpService;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column(new Col("Id"));
        table.column(new Col("Alias"));
        table.column(new Col("Servlet"));
        table.column(new Col("Servlet-Name"));
        table.column(new Col("Servlet-Info"));
        table.column(new Col("Servlet-Context-Path"));
        if (this.httpService instanceof HttpServiceImpl) {
            HttpServiceImpl httpServiceImpl = (HttpServiceImpl)this.httpService;
            Field handlerRegistryField = httpServiceImpl.getClass().getDeclaredField("handlerRegistry");
            handlerRegistryField.setAccessible(true);
            HandlerRegistry handlerRegistry = (HandlerRegistry)handlerRegistryField.get(httpServiceImpl);
            for (ServletHandler servletHandler : handlerRegistry.getServlets()) {
                table.addRow().addContent(new Object[]{servletHandler.getId(), servletHandler.getAlias(), servletHandler.getServlet().getClass(), servletHandler.getServlet().getServletConfig().getServletName(), servletHandler.getServlet().getServletInfo(), servletHandler.getServlet().getServletConfig().getServletContext().getContextPath()});
            }
            table.print(System.out, true);
        }
        return null;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }
}

