/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.AbstractHandler;
import org.apache.felix.http.base.internal.handler.ServletConfigImpl;
import org.apache.felix.http.base.internal.handler.ServletHandlerRequest;

public final class ServletHandler
extends AbstractHandler
implements Comparable<ServletHandler> {
    private static final Logger LOGGER = Logger.getLogger(ServletHandler.class.getName());
    private final String alias;
    private String aliasWithSlash;
    private String jspPathPrefix;
    private final boolean isRESTCall;
    private final Servlet servlet;

    public ServletHandler(ExtServletContext context, Servlet servlet, String alias) {
        super(context);
        this.servlet = servlet;
        if (alias != null) {
            if (alias.endsWith("*.jsp") && alias.length() > "*.jsp".length()) {
                this.jspPathPrefix = alias.substring(0, alias.lastIndexOf("*.jsp"));
                this.isRESTCall = false;
            } else {
                int jaxrsIndex = alias.indexOf(".jaxrs");
                if (jaxrsIndex > 0) {
                    alias = alias.substring(0, jaxrsIndex);
                    this.isRESTCall = true;
                } else {
                    this.isRESTCall = false;
                }
                this.aliasWithSlash = alias + "/";
            }
        } else {
            this.isRESTCall = false;
        }
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    @Override
    public void init() throws ServletException {
        String name = "servlet_" + this.getId();
        ServletConfigImpl config = new ServletConfigImpl(name, this.getContext(), this.getInitParams());
        this.servlet.init((ServletConfig)config);
    }

    @Override
    public void destroy() {
        this.servlet.destroy();
    }

    public boolean matches(String uri) {
        if (uri == null) {
            return this.alias.equals("/");
        }
        if (this.alias.equals("/")) {
            return uri.startsWith(this.alias);
        }
        return this.isRESTCall && uri.startsWith(this.alias) || uri.equals(this.alias) || this.jspPathPrefix == null && uri.startsWith(this.aliasWithSlash) || this.jspPathPrefix != null && uri.startsWith(this.jspPathPrefix) && uri.endsWith(".jsp");
    }

    public boolean handle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String includePathInfo = (String)req.getAttribute("javax.servlet.include.path_info");
        boolean matches = this.matches(includePathInfo != null ? includePathInfo : req.getPathInfo());
        if (matches) {
            if (includePathInfo != null) {
                this.handleInclude(req, res);
            } else {
                this.doHandle(req, res);
            }
        }
        return matches;
    }

    private void doHandle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.getContext().handleSecurity(req, res)) {
            this.servlet.service((ServletRequest)(this.jspPathPrefix == null && !this.isRESTCall ? new ServletHandlerRequest(req, this.alias) : req), (ServletResponse)res);
        } else if (!res.isCommitted() && res.getStatus() == 200) {
            res.sendError(403);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInclude(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Object oldLocalizationContext = req.getAttribute("javax.servlet.jsp.jstl.fmt.localizationContext.request");
        if (oldLocalizationContext != null) {
            try {
                Locale locale = (Locale)oldLocalizationContext.getClass().getMethod("getLocale", new Class[0]).invoke(oldLocalizationContext, new Object[0]);
                ResourceBundle oldBundle = (ResourceBundle)oldLocalizationContext.getClass().getMethod("getResourceBundle", new Class[0]).invoke(oldLocalizationContext, new Object[0]);
                req.setAttribute("javax.servlet.jsp.jstl.fmt.localizationContext.request", (Object)new LocalizationContext(oldBundle, locale));
            }
            catch (Exception e) {
                LOGGER.info("Couldn't call method on " + oldLocalizationContext + " object. Error was: " + e.getLocalizedMessage());
            }
        }
        try {
            this.servlet.service((ServletRequest)req, (ServletResponse)res);
        }
        finally {
            if (oldLocalizationContext != null) {
                req.setAttribute("javax.servlet.jsp.jstl.fmt.localizationContext.request", oldLocalizationContext);
            }
        }
    }

    @Override
    public int compareTo(ServletHandler other) {
        return other.alias.length() - this.alias.length();
    }
}

