/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.handler.ServletHandler;

public final class ServletPipeline {
    private final ServletHandler[] handlers;

    public ServletPipeline(ServletHandler[] handlers) {
        this.handlers = handlers;
    }

    public boolean handle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        for (ServletHandler handler : this.handlers) {
            if (!handler.handle(req, res)) continue;
            return true;
        }
        return false;
    }

    public boolean hasServletsMapped() {
        return this.handlers.length > 0;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        for (ServletHandler handler : this.handlers) {
            if (!handler.matches(path)) continue;
            return new Dispatcher(path, handler);
        }
        return null;
    }

    private final class Dispatcher
    implements RequestDispatcher {
        private final String path;
        private final ServletHandler handler;

        public Dispatcher(String path, ServletHandler handler) {
            this.path = path;
            this.handler = handler;
        }

        public void forward(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            if (res.isCommitted()) {
                throw new ServletException("Response has been committed");
            }
            res.resetBuffer();
            this.handler.handleInclude((HttpServletRequest)req, (HttpServletResponse)res);
        }

        public void include(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            this.handler.handleInclude((HttpServletRequest)req, (HttpServletResponse)res);
        }
    }
}

