/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bundles.jaas;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.jahia.services.pwd.PasswordService;
import org.jahia.settings.SettingsBean;

public class JahiaLoginModule
extends AbstractKarafLoginModule {
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, options);
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        if (this.callbackHandler != null) {
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (IOException e) {
                throw new LoginException(e.getMessage());
            }
            catch (UnsupportedCallbackException e) {
                throw new LoginException(e.getMessage() + " not available to obtain information from user");
            }
        }
        if (((NameCallback)callbacks[0]).getName() == null) {
            throw new LoginException("Username can not be null");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        if (((PasswordCallback)callbacks[1]).getPassword() == null) {
            throw new LoginException("Password can not be null");
        }
        String password = new String(((PasswordCallback)callbacks[1]).getPassword());
        boolean userCheck = this.user.equals(SettingsBean.getInstance().getPropertiesFile().getProperty("jahiaToolManagerUsername"));
        if (!userCheck) {
            throw new FailedLoginException("User " + this.user + " does not exist");
        }
        boolean passwordCheck = PasswordService.getInstance().matches(password, SettingsBean.getInstance().getPropertiesFile().getProperty("jahiaToolManagerPassword"));
        if (!passwordCheck) {
            throw new FailedLoginException("Password for " + this.user + " does not match");
        }
        this.principals = new HashSet();
        this.principals.add(new UserPrincipal(this.user));
        this.principals.add(new GroupPrincipal("admingroup"));
        this.principals.add(new RolePrincipal("group"));
        this.principals.add(new RolePrincipal("admin"));
        this.principals.add(new RolePrincipal("manager"));
        this.principals.add(new RolePrincipal("viewer"));
        this.principals.add(new RolePrincipal("systembundles"));
        return true;
    }

    public boolean abort() throws LoginException {
        this.clear();
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }
}

