/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.commons;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern VERSION_NUMBER_PATTERN = Pattern.compile("^([0-9\\.]*[0-9]+)(.*)");
    public static final String MAVEN_LATEST_VERSION = "LATEST";
    public static final String MAVEN_SNAPSHOT_VERSION = "SNAPSHOT";
    public static final Pattern MAVEN_VERSION_FILE_PATTERN = Pattern.compile("^(.*)-([0-9]{8}.[0-9]{6})-([0-9]+)$");
    public static final Pattern FILE_NAME_VERSION_PATTERN = Pattern.compile("^(.*?)-(([0-9\\.]*[0-9]+)(.*))?$");
    private List<Integer> orderedVersionNumbers = new ArrayList<Integer>();
    private int betaNumber = -1;
    private int releaseCandidateNumber = -1;
    private String version;
    private String versionPartSuffix;
    private String updateMarker;
    private List<String> qualifiers = new ArrayList<String>();

    public Version(String versionString) throws NumberFormatException {
        if (versionString == null) {
            throw new NumberFormatException("Null string passed as version !");
        }
        if (versionString.length() == 0) {
            throw new NumberFormatException("Empty string passed as version !");
        }
        String trimmedVersionString = versionString.trim();
        String versionPart = null;
        String numberedVersionPart = null;
        StringTokenizer tokenizer = new StringTokenizer(trimmedVersionString, "-");
        versionPart = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            this.qualifiers.add(tokenizer.nextToken());
        }
        Matcher versionPartMatcher = VERSION_NUMBER_PATTERN.matcher(versionPart);
        if (!versionPartMatcher.matches()) {
            this.qualifiers.add(0, versionPart);
            versionPart = null;
        } else {
            numberedVersionPart = versionPartMatcher.group(1);
            this.versionPartSuffix = versionPartMatcher.group(2);
        }
        if (versionPart != null) {
            int underscorePos;
            String rest;
            versionPart = versionPart.toLowerCase();
            int betaPos = versionPart.indexOf("b");
            int rcPos = versionPart.indexOf("rc");
            if (betaPos != -1) {
                String betaString = versionPart.substring(betaPos + 1).trim();
                rest = versionPart.substring(0, betaPos);
                try {
                    this.betaNumber = Integer.parseInt(betaString);
                    versionPart = rest;
                    this.versionPartSuffix = null;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (rcPos != -1) {
                String rcString = versionPart.substring(rcPos + 2).trim();
                rest = versionPart.substring(0, rcPos);
                try {
                    this.releaseCandidateNumber = Integer.parseInt(rcString);
                    versionPart = rest;
                    this.versionPartSuffix = null;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((underscorePos = versionPart.indexOf("_")) != -1) {
                this.updateMarker = versionPart.substring(underscorePos + 1).trim();
                versionPart = versionPart.substring(0, underscorePos).trim();
                this.versionPartSuffix = null;
            }
            StringTokenizer versionTokenizer = new StringTokenizer(numberedVersionPart, ".");
            while (versionTokenizer.hasMoreTokens()) {
                String curToken = versionTokenizer.nextToken().trim();
                try {
                    int curVersionNumber = Integer.parseInt(curToken);
                    this.orderedVersionNumbers.add(new Integer(curVersionNumber));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    String getBaseVersionString() {
        StringBuffer baseVersionBuf = new StringBuffer();
        for (Integer orderedVersionNumber : this.orderedVersionNumbers) {
            baseVersionBuf.append(orderedVersionNumber);
            baseVersionBuf.append(".");
        }
        String baseVersionString = baseVersionBuf.toString();
        return baseVersionString.substring(0, baseVersionString.length() - 1);
    }

    public boolean isBeta() {
        return this.betaNumber != -1;
    }

    public boolean isReleaseCandidate() {
        return this.releaseCandidateNumber != -1;
    }

    public boolean isFinal() {
        return this.betaNumber == -1 && this.releaseCandidateNumber == -1;
    }

    public String getVersionPartSuffix() {
        return this.versionPartSuffix;
    }

    public String toString() {
        if (this.version == null) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.orderedVersionNumbers.size(); ++i) {
                Integer curVersionNumber = this.orderedVersionNumbers.get(i);
                result.append(curVersionNumber);
                if (i >= this.orderedVersionNumbers.size() - 1) continue;
                result.append(".");
            }
            if (this.versionPartSuffix != null) {
                result.append(this.versionPartSuffix);
            }
            if (this.betaNumber != -1) {
                result.append("b");
                result.append(this.betaNumber);
            } else if (this.releaseCandidateNumber != -1) {
                result.append("rc");
                result.append(this.releaseCandidateNumber);
            }
            if (this.updateMarker != null) {
                result.append("_");
                result.append(this.updateMarker);
            }
            if (this.qualifiers.size() > 0) {
                for (String qualifier : this.qualifiers) {
                    result.append("-");
                    result.append(qualifier);
                }
            }
            this.version = result.toString();
        }
        return this.version;
    }

    @Override
    public int compareTo(Version o) {
        Version rightVersion = o;
        List<Integer> rightOrderedVersionNumbers = rightVersion.getOrderedVersionNumbers();
        if (this.equals(rightVersion)) {
            return 0;
        }
        if (this.orderedVersionNumbers.size() == rightOrderedVersionNumbers.size()) {
            for (int i = 0; i < this.orderedVersionNumbers.size(); ++i) {
                Integer versionNumber = this.orderedVersionNumbers.get(i);
                Integer rightVersionNumber = rightOrderedVersionNumbers.get(i);
                if (versionNumber.intValue() == rightVersionNumber.intValue()) continue;
                return versionNumber.compareTo(rightVersionNumber);
            }
            if (this.isBeta() && rightVersion.isBeta()) {
                if (this.betaNumber < rightVersion.getBetaNumber()) {
                    return -1;
                }
                return 1;
            }
            if (this.isReleaseCandidate() && rightVersion.isReleaseCandidate()) {
                if (this.releaseCandidateNumber < rightVersion.getReleaseCandidateNumber()) {
                    return -1;
                }
                return 1;
            }
            if (this.isBeta() && rightVersion.isReleaseCandidate()) {
                return -1;
            }
            if (this.isBeta() && rightVersion.isFinal()) {
                return -1;
            }
            if (this.isReleaseCandidate() && rightVersion.isBeta()) {
                return 1;
            }
            if (this.isReleaseCandidate() && rightVersion.isFinal()) {
                return -1;
            }
            if (this.isFinal() && rightVersion.isBeta()) {
                return 1;
            }
            if (this.isFinal() && rightVersion.isReleaseCandidate()) {
                return 1;
            }
            return 0;
        }
        if (this.orderedVersionNumbers.size() < rightOrderedVersionNumbers.size()) {
            for (int i = 0; i < this.orderedVersionNumbers.size(); ++i) {
                Integer versionNumber = this.orderedVersionNumbers.get(i);
                Integer rightVersionNumber = rightOrderedVersionNumbers.get(i);
                if (versionNumber.intValue() == rightVersionNumber.intValue()) continue;
                return versionNumber.compareTo(rightVersionNumber);
            }
            return -1;
        }
        for (int i = 0; i < rightOrderedVersionNumbers.size(); ++i) {
            Integer versionNumber = this.orderedVersionNumbers.get(i);
            Integer rightVersionNumber = rightOrderedVersionNumbers.get(i);
            if (versionNumber.intValue() == rightVersionNumber.intValue()) continue;
            return versionNumber.compareTo(rightVersionNumber);
        }
        return 1;
    }

    public List<Integer> getOrderedVersionNumbers() {
        return this.orderedVersionNumbers;
    }

    public int getBetaNumber() {
        return this.betaNumber;
    }

    public int getReleaseCandidateNumber() {
        return this.releaseCandidateNumber;
    }

    public String getUpdateMarker() {
        return this.updateMarker;
    }

    public List<String> getQualifiers() {
        return this.qualifiers;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            int i;
            int sizeDiff;
            Version rightVersion = (Version)obj;
            ArrayList<Integer> normalizedOrderedVersionNumbers = new ArrayList<Integer>(this.orderedVersionNumbers);
            ArrayList<Integer> normalizedRightOrderedVersionNumbers = new ArrayList<Integer>(rightVersion.getOrderedVersionNumbers());
            if (normalizedOrderedVersionNumbers.size() < normalizedRightOrderedVersionNumbers.size()) {
                sizeDiff = normalizedRightOrderedVersionNumbers.size() - normalizedOrderedVersionNumbers.size();
                for (i = 0; i < sizeDiff; ++i) {
                    normalizedOrderedVersionNumbers.add(0);
                }
            } else if (normalizedOrderedVersionNumbers.size() > normalizedRightOrderedVersionNumbers.size()) {
                sizeDiff = normalizedOrderedVersionNumbers.size() - normalizedRightOrderedVersionNumbers.size();
                for (i = 0; i < sizeDiff; ++i) {
                    normalizedRightOrderedVersionNumbers.add(0);
                }
            }
            if (this.betaNumber != rightVersion.getBetaNumber()) {
                return false;
            }
            if (this.releaseCandidateNumber != rightVersion.getReleaseCandidateNumber()) {
                return false;
            }
            for (int i2 = 0; i2 < normalizedOrderedVersionNumbers.size(); ++i2) {
                Integer leftVersionNumber = (Integer)normalizedOrderedVersionNumbers.get(i2);
                Integer rightVersionNumber = (Integer)normalizedRightOrderedVersionNumbers.get(i2);
                if (leftVersionNumber.intValue() == rightVersionNumber.intValue()) continue;
                return false;
            }
            if (this.updateMarker != null && rightVersion.getUpdateMarker() != null) {
                if (!this.updateMarker.equals(rightVersion.getUpdateMarker())) {
                    return false;
                }
            } else if (this.updateMarker != null || rightVersion.getUpdateMarker() != null) {
                return false;
            }
            return this.qualifiers.equals(rightVersion.getQualifiers());
        }
        return false;
    }

    public int getMajorVersion() {
        if (this.orderedVersionNumbers.size() > 0) {
            return this.orderedVersionNumbers.get(0);
        }
        return 0;
    }

    public int getMinorVersion() {
        if (this.orderedVersionNumbers.size() > 1) {
            return this.orderedVersionNumbers.get(1);
        }
        return 0;
    }

    public int getServicePackVersion() {
        if (this.orderedVersionNumbers.size() > 2) {
            return this.orderedVersionNumbers.get(2);
        }
        return 0;
    }

    public int getPatchVersion() {
        if (this.orderedVersionNumbers.size() > 3) {
            return this.orderedVersionNumbers.get(3);
        }
        return 0;
    }

    public static Version fromMavenFileName(String fileNameWithoutExtension) {
        Matcher fileNameMatcher = FILE_NAME_VERSION_PATTERN.matcher(fileNameWithoutExtension);
        if (fileNameMatcher.matches()) {
            return new Version(fileNameMatcher.group(2));
        }
        return null;
    }
}

