/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.util.Collections;
import java.util.Map;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jahia.configuration.logging.AbstractLogger;

public abstract class AbstractConfigurator {
    protected Map dbProperties = Collections.emptyMap();
    protected JahiaConfigInterface jahiaConfigInterface;
    private AbstractLogger logger;

    protected static String getValue(Map values, String key) {
        String replacement = (String)values.get(key);
        if (replacement == null) {
            return "";
        }
        replacement = replacement.trim();
        return replacement;
    }

    public AbstractConfigurator(JahiaConfigInterface jahiaConfigInterface) {
        this.jahiaConfigInterface = jahiaConfigInterface;
    }

    public AbstractConfigurator(Map dbProps, JahiaConfigInterface jahiaConfigInterface) {
        this(jahiaConfigInterface);
        this.dbProperties = dbProps;
    }

    public AbstractConfigurator(Map dbProps, JahiaConfigInterface jahiaConfigInterface, AbstractLogger logger) {
        this(jahiaConfigInterface);
        this.dbProperties = dbProps;
        this.logger = logger;
    }

    public abstract void updateConfiguration(ConfigFile var1, String var2) throws Exception;

    protected String getDBProperty(String key) {
        return AbstractConfigurator.getValue(this.dbProperties, key);
    }

    public AbstractLogger getLogger() {
        return this.logger;
    }

    public void setLogger(AbstractLogger logger) {
        this.logger = logger;
    }
}

