/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.jahia.configuration.configurators.ConfigFile;

public class VFSConfigFile
implements ConfigFile,
Closeable {
    private static Set<Closeable> OPENED = new HashSet<Closeable>();
    private FileObject fileObject;

    public static synchronized void closeAllOpened() {
        Iterator<Closeable> iterator = OPENED.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                iterator.remove();
            }
        }
    }

    public VFSConfigFile(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public VFSConfigFile(FileObject parentFileObject, String path) throws FileSystemException {
        this.fileObject = parentFileObject.resolveFile(path);
    }

    public VFSConfigFile(FileSystemManager fileSystemManager, String uri) throws FileSystemException {
        this.fileObject = fileSystemManager.resolveFile(uri);
    }

    @Override
    public void close() throws IOException {
        if (this.fileObject != null) {
            this.fileObject.close();
            this.fileObject.getFileSystem().getFileSystemManager().closeFileSystem(this.fileObject.getFileSystem());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws FileSystemException {
        Set<Closeable> set = OPENED;
        synchronized (set) {
            OPENED.add(this);
        }
        return this.fileObject.getContent().getInputStream();
    }

    @Override
    public URI getURI() throws FileSystemException, URISyntaxException {
        return this.fileObject.getURL().toURI();
    }
}

