/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.normalization;

import com.ibm.icu.text.Normalizer;
import java.text.Normalizer;
import org.jasypt.exceptions.EncryptionInitializationException;

public final class Normalizer {
    private static final String ICU_NORMALIZER_CLASS_NAME = "com.ibm.icu.text.Normalizer";
    private static final String JDK_NORMALIZER_CLASS_NAME = "java.text.Normalizer";
    private static Boolean useIcuNormalizer = null;

    public static String normalizeToNfc(String message) {
        return new String(Normalizer.normalizeToNfc(message.toCharArray()));
    }

    public static char[] normalizeToNfc(char[] message) {
        if (useIcuNormalizer == null) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass(ICU_NORMALIZER_CLASS_NAME);
                useIcuNormalizer = Boolean.TRUE;
            }
            catch (ClassNotFoundException e) {
                try {
                    Thread.currentThread().getContextClassLoader().loadClass(JDK_NORMALIZER_CLASS_NAME);
                }
                catch (ClassNotFoundException e2) {
                    throw new EncryptionInitializationException("Cannot find a valid UNICODE normalizer: neither java.text.Normalizer nor com.ibm.icu.text.Normalizer have been found at the classpath. If you are using a version of the JDK older than JavaSE 6, you should include the icu4j library in your classpath.");
                }
                useIcuNormalizer = Boolean.FALSE;
            }
        }
        if (useIcuNormalizer.booleanValue()) {
            return Normalizer.normalizeWithIcu4j(message);
        }
        return Normalizer.normalizeWithJavaNormalizer(message);
    }

    private static char[] normalizeWithJavaNormalizer(char[] message) {
        String messageStr = new String(message);
        String result = java.text.Normalizer.normalize(messageStr, Normalizer.Form.NFC);
        return result.toCharArray();
    }

    private static char[] normalizeWithIcu4j(char[] message) {
        char[] normalizationResult = new char[message.length * 2];
        int normalizationResultSize = 0;
        while (true) {
            if ((normalizationResultSize = com.ibm.icu.text.Normalizer.normalize((char[])message, (char[])normalizationResult, (Normalizer.Mode)com.ibm.icu.text.Normalizer.NFC, (int)0)) <= normalizationResult.length) {
                char[] result = new char[normalizationResultSize];
                System.arraycopy(normalizationResult, 0, result, 0, normalizationResultSize);
                for (int i = 0; i < normalizationResult.length; ++i) {
                    normalizationResult[i] = '\u0000';
                }
                return result;
            }
            for (int i = 0; i < normalizationResult.length; ++i) {
                normalizationResult[i] = '\u0000';
            }
            normalizationResult = new char[normalizationResultSize];
        }
    }

    private Normalizer() {
    }
}

