/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.viewhelper.principal.PrincipalViewHelper;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.usermanager.SearchCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageContext;
import org.springframework.webflow.execution.RequestContext;

public class RolesHandler
implements Serializable {
    private static final long serialVersionUID = 2485636561921483297L;
    private static final Logger logger = LoggerFactory.getLogger(RolesHandler.class);
    @Autowired
    private transient JahiaUserManagerService userManagerService;
    @Autowired
    private transient JahiaGroupManagerService groupManagerService;
    @Autowired
    private transient JCRPublicationService publicationService;
    private String workspace;
    private Locale locale;
    private Locale fallbackLocale;
    private String roleGroup;
    private String searchType = "users";
    private String role;
    private String nodePath;
    private List<String> roles;

    public String getRoleGroup() {
        return this.roleGroup;
    }

    public void setRoleGroup(String roleGroup) {
        this.roleGroup = roleGroup;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }

    public Map<JCRNodeWrapper, List<JCRNodeWrapper>> getRoles() throws Exception {
        Query q;
        HashMap<String, JCRNodeWrapper> rolesFromName = new HashMap<String, JCRNodeWrapper>();
        TreeMap<JCRNodeWrapper, List<JCRNodeWrapper>> result = new TreeMap<JCRNodeWrapper, List<JCRNodeWrapper>>(new Comparator<JCRNodeWrapper>(){

            @Override
            public int compare(JCRNodeWrapper jcrNodeWrapper, JCRNodeWrapper jcrNodeWrapper2) {
                return jcrNodeWrapper.getDisplayableName().compareTo(jcrNodeWrapper2.getDisplayableName());
            }
        });
        JCRSessionWrapper defaultSession = JCRSessionFactory.getInstance().getCurrentUserSession(null, this.locale, this.fallbackLocale);
        QueryManagerWrapper qm = defaultSession.getWorkspace().getQueryManager();
        if (this.role != null) {
            q = qm.createQuery("select * from [jnt:role] where localname()='" + JCRContentUtils.sqlEncode((String)this.role) + "'", "JCR-SQL2");
            this.getRoles(q, rolesFromName, result);
        } else if (this.roles == null) {
            q = qm.createQuery("select * from [jnt:role] where [j:roleGroup]='" + JCRContentUtils.sqlEncode((String)this.roleGroup) + "'", "JCR-SQL2");
            this.getRoles(q, rolesFromName, result);
        } else {
            for (String r : this.roles) {
                Query q2 = qm.createQuery("select * from [jnt:role] where localname()='" + JCRContentUtils.sqlEncode((String)r) + "'", "JCR-SQL2");
                this.getRoles(q2, rolesFromName, result);
            }
        }
        JCRSessionWrapper s = JCRSessionFactory.getInstance().getCurrentUserSession(this.workspace, this.locale, this.fallbackLocale);
        JCRNodeWrapper node = s.getNode(this.nodePath);
        Map acl = node.getAclEntries();
        String siteKey = this.nodePath.startsWith("/sites/") ? StringUtils.substringBefore((String)StringUtils.substringAfter((String)this.nodePath, (String)"/sites/"), (String)"/") : null;
        for (Map.Entry entry : acl.entrySet()) {
            JCRUserNode p = null;
            if (((String)entry.getKey()).startsWith("u:")) {
                p = this.userManagerService.lookupUser(((String)entry.getKey()).substring(2), siteKey);
            } else if (((String)entry.getKey()).startsWith("g:")) {
                if (siteKey != null) {
                    p = this.groupManagerService.lookupGroup(siteKey, ((String)entry.getKey()).substring(2));
                }
                if (p == null) {
                    p = this.groupManagerService.lookupGroup(null, ((String)entry.getKey()).substring(2));
                }
            }
            if (p == null) continue;
            List value = (List)entry.getValue();
            Collections.reverse(value);
            for (String[] strings : value) {
                String role = strings[2];
                if (strings[1].equals("GRANT") && rolesFromName.containsKey(role) && !((List)result.get(rolesFromName.get(role))).contains(p)) {
                    ((List)result.get(rolesFromName.get(role))).add(p);
                    continue;
                }
                if (!strings[1].equals("DENY") || !rolesFromName.containsKey(role)) continue;
                ((List)result.get(rolesFromName.get(role))).remove(p);
            }
        }
        return result;
    }

    private void getRoles(Query q, Map<String, JCRNodeWrapper> rolesFromName, Map<JCRNodeWrapper, List<JCRNodeWrapper>> m) throws RepositoryException {
        NodeIterator ni = q.execute().getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper next = (JCRNodeWrapper)ni.next();
            m.put(next, new ArrayList());
            rolesFromName.put(next.getName(), next);
        }
    }

    public void setContext(JCRNodeWrapper node, RenderContext context) throws RepositoryException {
        if (node.hasProperty("roles")) {
            this.roles = new ArrayList<String>();
            for (JCRValueWrapper value : node.getProperty("roles").getValues()) {
                this.roles.add(value.getString());
            }
        } else {
            this.roles = null;
        }
        if (node.hasProperty("roleGroup")) {
            this.roleGroup = node.getProperty("roleGroup").getString();
        }
        this.nodePath = node.hasProperty("contextNodePath") ? node.getProperty("contextNodePath").getString() : context.getMainResource().getNode().getPath();
        this.workspace = node.getSession().getWorkspace().getName();
        this.locale = node.getSession().getLocale();
        this.fallbackLocale = node.getSession().getFallbackLocale();
    }

    public List<JCRNodeWrapper> getRoleMembers() throws Exception {
        Map<JCRNodeWrapper, List<JCRNodeWrapper>> r = this.getRoles();
        return r.size() > 0 ? r.entrySet().iterator().next().getValue() : new ArrayList<JCRNodeWrapper>();
    }

    public void grantRole(String[] principals, MessageContext messageContext) throws Exception {
        if (principals.length == 0) {
            return;
        }
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(this.workspace, this.locale, this.fallbackLocale);
        for (String principal : principals) {
            session.getNode(this.nodePath).grantRoles(principal, Collections.singleton(this.role));
        }
        session.save();
        if ("default".equals(this.workspace) && session.getNode(this.nodePath).hasNode("j:acl")) {
            this.publicationService.publishByMainId(session.getNode(this.nodePath).getNode("j:acl").getIdentifier());
        }
    }

    public void revokeRole(String[] principals, MessageContext messageContext) throws Exception {
        if (principals.length == 0) {
            return;
        }
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(this.workspace, this.locale, this.fallbackLocale);
        HashMap<String, String> roles = new HashMap<String, String>();
        for (String principal : principals) {
            List entries = (List)session.getNode(this.nodePath).getAclEntries().get(principal);
            for (String[] strings : entries) {
                if (!this.role.equals(strings[2])) {
                    roles.put(strings[2], strings[1]);
                    continue;
                }
                if (strings[0].equals(this.nodePath)) continue;
                roles.put(strings[2], "DENY");
            }
            session.getNode(this.nodePath).revokeRolesForPrincipal(principal);
            session.getNode(this.nodePath).changeRoles(principal, roles);
        }
        session.save();
        if ("default".equals(this.workspace) && session.getNode(this.nodePath).hasNode("j:acl")) {
            this.publicationService.publishByMainId(session.getNode(this.nodePath).getNode("j:acl").getIdentifier());
        }
    }

    public SearchCriteria initCriteria(RequestContext ctx) {
        return new SearchCriteria(null);
    }

    public Map<String, JCRStoreProvider> getProviders() {
        LinkedHashMap<String, JCRStoreProvider> providers = new LinkedHashMap<String, JCRStoreProvider>();
        return providers;
    }

    public Set<JCRNodeWrapper> searchNewMembers(SearchCriteria searchCriteria) throws RepositoryException {
        HashSet<JCRNodeWrapper> searchResult;
        long timer = System.currentTimeMillis();
        if (this.searchType.equals("users")) {
            searchResult = new HashSet<JCRNodeWrapper>(PrincipalViewHelper.getSearchResult((String)searchCriteria.getSearchIn(), null, (String)searchCriteria.getSearchString(), (String[])searchCriteria.getProperties(), (String)searchCriteria.getStoredOn(), (String[])searchCriteria.getProviders()));
        } else {
            String siteKey = null;
            if (this.nodePath.startsWith("/sites/")) {
                siteKey = StringUtils.substringAfter((String)this.nodePath, (String)"/sites/");
            }
            searchResult = new HashSet(PrincipalViewHelper.getGroupSearchResult((String)searchCriteria.getSearchIn(), (String)siteKey, (String)searchCriteria.getSearchString(), (String[])searchCriteria.getProperties(), (String)searchCriteria.getStoredOn(), (String[])searchCriteria.getProviders()));
        }
        logger.info("Found {} groups in {} ms", (Object)searchResult.size(), (Object)(System.currentTimeMillis() - timer));
        return searchResult;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public String getSearchType() {
        return this.searchType;
    }
}

