/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartWorkflowAction
extends Action {
    protected WorkflowService workflowService;
    private static Logger logger = LoggerFactory.getLogger(StartWorkflowAction.class);

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        if (parameters.get("process") == null) {
            logger.error("Missing parameter: \"process\" with value <workflow provider>:<workflow key>");
            return ActionResult.BAD_REQUEST;
        }
        String process = parameters.get("process").get(0);
        String workflowDefinitionKey = StringUtils.substringAfter((String)process, (String)":");
        String providerKey = StringUtils.substringBefore((String)process, (String)":");
        String formNodeType = (String)this.workflowService.getWorkflowRegistration(workflowDefinitionKey).getForms().get("start");
        HashMap map = WorkflowVariable.getVariablesMap(parameters, (String)formNodeType, Arrays.asList("process"));
        this.workflowService.startProcess(Arrays.asList(resource.getNode().getIdentifier()), session, workflowDefinitionKey, providerKey, (Map)map, null);
        return ActionResult.OK_JSON;
    }
}

