/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;

public class AddMemberToAcl
extends Action {
    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        JCRNodeWrapper node = resource.getNode();
        String member = req.getParameter("memberKey");
        String role = req.getParameter("role");
        boolean revoke = StringUtils.isEmpty((String)role);
        if (!StringUtils.isEmpty((String)member)) {
            boolean performAdd = true;
            if (revoke || Boolean.valueOf(req.getParameter("overwrite")).booleanValue()) {
                node.revokeRolesForPrincipal(member);
            } else {
                JCRNodeWrapper acl;
                JCRNodeWrapper jCRNodeWrapper = acl = node.hasNode("j:acl") ? node.getNode("j:acl") : null;
                if (acl != null) {
                    JCRNodeIteratorWrapper ni = acl.getNodes();
                    while (ni.hasNext()) {
                        Node ace = ni.nextNode();
                        if (!ace.getProperty("j:principal").getString().equals(member)) continue;
                        performAdd = false;
                        break;
                    }
                }
            }
            if (!revoke && performAdd) {
                node.grantRoles(member, Collections.singleton(role));
            }
            if (revoke || performAdd) {
                node.getSession().save();
            }
        }
        return ActionResult.OK_JSON;
    }
}

