/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddMemberToGroupAction
extends Action {
    private static transient Logger logger = LoggerFactory.getLogger(AddMemberToGroupAction.class);
    private JahiaGroupManagerService jahiaGroupManagerService;
    private JahiaUserManagerService jahiaUserManagerService;

    public void setJahiaGroupManagerService(JahiaGroupManagerService jahiaGroupManagerService) {
        this.jahiaGroupManagerService = jahiaGroupManagerService;
    }

    public void setJahiaUserManagerService(JahiaUserManagerService jahiaUserManagerService) {
        this.jahiaUserManagerService = jahiaUserManagerService;
    }

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        String groupPath = resource.getNode().getPath();
        String[] splitGroupPath = groupPath.split("/");
        String siteKey = null;
        String groupName = null;
        if (groupPath.startsWith("/sites")) {
            siteKey = splitGroupPath[2];
            groupName = splitGroupPath[4];
        } else {
            groupName = splitGroupPath[2];
        }
        JCRGroupNode targetJahiaGroup = this.jahiaGroupManagerService.lookupGroup(siteKey, groupName, session);
        if (parameters.get("userKey") != null) {
            String userKey = parameters.get("userKey").get(0);
            JCRUserNode jahiaUser = this.jahiaUserManagerService.lookupUserByPath(userKey);
            if (jahiaUser == null) {
                logger.warn("User " + userKey + " could not be found, will not add as member of group " + targetJahiaGroup.getPath());
                return ActionResult.BAD_REQUEST;
            }
            if (!targetJahiaGroup.isMember((JCRNodeWrapper)jahiaUser)) {
                targetJahiaGroup.addMember((JCRNodeWrapper)jahiaUser);
            }
        } else if (parameters.get("groupKey") != null) {
            String groupKey = parameters.get("groupKey").get(0);
            JCRGroupNode jahiaGroup = this.jahiaGroupManagerService.lookupGroupByPath(groupKey);
            if (jahiaGroup == null) {
                logger.warn("Group " + groupKey + " could not be found, will not add as member of group " + targetJahiaGroup.getPath());
                return ActionResult.BAD_REQUEST;
            }
            if (!targetJahiaGroup.isMember((JCRNodeWrapper)jahiaGroup)) {
                targetJahiaGroup.addMember((JCRNodeWrapper)jahiaGroup);
            }
        } else {
            return ActionResult.BAD_REQUEST;
        }
        session.save();
        return ActionResult.OK_JSON;
    }
}

