/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPrincipalsInRolesAction
extends Action {
    private static transient Logger logger = LoggerFactory.getLogger(AddPrincipalsInRolesAction.class);
    private JahiaGroupManagerService jahiaGroupManagerService;
    private JahiaUserManagerService jahiaUserManagerService;

    public void setJahiaGroupManagerService(JahiaGroupManagerService jahiaGroupManagerService) {
        this.jahiaGroupManagerService = jahiaGroupManagerService;
    }

    public void setJahiaUserManagerService(JahiaUserManagerService jahiaUserManagerService) {
        this.jahiaUserManagerService = jahiaUserManagerService;
    }

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        if (parameters.get("principals") != null && parameters.get("roles") != null) {
            List<String> principals = parameters.get("principals");
            List<String> roles = parameters.get("roles");
            String siteKey = resource.getNode().getResolveSite().getSiteKey();
            for (String principalKey : principals) {
                if (principalKey.startsWith("u:")) {
                    String user = principalKey.substring("u:".length());
                    JCRUserNode jahiaUser = this.jahiaUserManagerService.lookupUser(user, siteKey);
                    if (jahiaUser == null) {
                        logger.warn("User " + user + " could not be found, will not add to roles");
                        return ActionResult.BAD_REQUEST;
                    }
                    resource.getNode().grantRoles(principalKey, new HashSet<String>(roles));
                    session.save();
                    continue;
                }
                if (!principalKey.startsWith("g:")) continue;
                String group = principalKey.substring("g:".length());
                JCRGroupNode jahiaGroup = this.jahiaGroupManagerService.lookupGroup(siteKey, group);
                if (jahiaGroup == null) {
                    jahiaGroup = this.jahiaGroupManagerService.lookupGroup(null, group);
                }
                if (jahiaGroup == null) {
                    logger.warn("Group " + group + " could not be found, will not add to roles");
                    return ActionResult.BAD_REQUEST;
                }
                resource.getNode().grantRoles(principalKey, new HashSet<String>(roles));
                session.save();
            }
        } else {
            return ActionResult.BAD_REQUEST;
        }
        return ActionResult.OK_JSON;
    }
}

