/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoPublicationAction
extends Action {
    private static final Logger logger = LoggerFactory.getLogger(AutoPublicationAction.class);
    private JCRPublicationService publicationService;

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        boolean enable = Boolean.valueOf(AutoPublicationAction.getParameter(parameters, (String)"enable", (String)"true"));
        boolean unpublish = !enable && Boolean.valueOf(AutoPublicationAction.getParameter(parameters, (String)"unpublish", (String)"true")) != false;
        JCRNodeWrapper node = resource.getNode();
        if (enable) {
            if (!node.isNodeType("jmix:autoPublish")) {
                session.checkout((Node)node);
                node.addMixin("jmix:autoPublish");
                session.save();
                if (logger.isDebugEnabled()) {
                    logger.debug("Made node {} auto-published", (Object)node.getPath());
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Node {} is already auto-published", (Object)node.getPath());
            }
        } else if (node.isNodeType("jmix:autoPublish")) {
            session.checkout((Node)node);
            node.removeMixin("jmix:autoPublish");
            session.save();
            if (logger.isDebugEnabled()) {
                logger.debug("Reverted auto-publishing on the node {}", (Object)node.getPath());
            }
        }
        if (unpublish) {
            this.publicationService.unpublish((List)ImmutableList.of((Object)node.getIdentifier()));
            if (logger.isDebugEnabled()) {
                logger.debug("Unpublished node {}", (Object)node.getPath());
            }
        }
        return ActionResult.OK_JSON;
    }

    public void setPublicationService(JCRPublicationService publicationService) {
        this.publicationService = publicationService;
    }
}

