/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions;

import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.bin.DefaultPostAction;
import org.jahia.bin.Render;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.springframework.beans.factory.InitializingBean;

public class ChainAction
extends Action
implements InitializingBean {
    private JahiaTemplateManagerService templateService;
    private DefaultPostAction defaultPostAction;
    private URLResolverFactory urlResolverFactory;
    public static final String ACTION_NAME = "chain";
    public static final String CHAIN_OF_ACTION = "chainOfAction";

    public ChainAction() {
        this.setName(ACTION_NAME);
    }

    public void setTemplateService(JahiaTemplateManagerService templateService) {
        this.templateService = templateService;
    }

    public void setUrlResolverFactory(URLResolverFactory urlResolverFactory) {
        this.urlResolverFactory = urlResolverFactory;
    }

    public void setDefaultPostAction(DefaultPostAction defaultPostAction) {
        this.defaultPostAction = defaultPostAction;
    }

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        List<String> chainOfactions = parameters.get(CHAIN_OF_ACTION);
        if (chainOfactions != null) {
            String[] actions = chainOfactions.get(0).split(",");
            Map actionsMap = this.templateService.getActions();
            ActionResult result = null;
            String path = null;
            for (String actionToDo : actions) {
                if ("default".equals(actionToDo)) {
                    String s = urlResolver.getUrlPathInfo().replace(".chain.do", "/*");
                    URLResolver resolver = this.urlResolverFactory.createURLResolver(s, req.getServerName(), req);
                    resolver.setSiteKey(urlResolver.getSiteKey());
                    result = this.defaultPostAction.doExecute(req, renderContext, resource, session, parameters, resolver);
                    continue;
                }
                Action action = (Action)actionsMap.get(actionToDo);
                if (action.getRequiredPermission() != null && !resource.getNode().hasPermission(action.getRequiredPermission())) {
                    throw new AccessDeniedException();
                }
                result = action.doExecute(req, renderContext, resource, session, parameters, urlResolver);
                if (!actionToDo.equals("redirect") || result == null || result.getUrl() == null) continue;
                path = result.getUrl();
            }
            if (path != null) {
                result.setUrl(path);
            }
            return result;
        }
        return ActionResult.BAD_REQUEST;
    }

    public void afterPropertiesSet() throws Exception {
        Render.getReservedParameters().add(CHAIN_OF_ACTION);
    }
}

