/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions;

import java.net.URLEncoder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.json.JSONObject;

public class CheckClipboardAction
extends Action {
    public static final String UUIDS = "uuids[]";

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        List uuids = (List)req.getSession().getAttribute("org.jahia.uuids.to.copy");
        List uuidstoCut = (List)req.getSession().getAttribute("org.jahia.uuids.to.cut");
        if (uuids == null) {
            uuids = uuidstoCut;
        } else if (uuidstoCut != null) {
            uuids.addAll(uuidstoCut);
        }
        if (uuids != null && uuids.size() > 0) {
            JSONObject json = new JSONObject();
            json.put(URLEncoder.encode(UUIDS, "UTF-8"), (Collection)uuids);
            LinkedList<String> paths = new LinkedList<String>();
            LinkedList<String> nodetypes = new LinkedList<String>();
            for (String uuid : uuids) {
                try {
                    JCRNodeWrapper nodeByUUID = session.getNodeByUUID(uuid);
                    paths.add(nodeByUUID.getPath());
                    List nodeTypes = nodeByUUID.getNodeTypes();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String nodeType : nodeTypes) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(" ");
                        }
                        stringBuilder.append(nodeType);
                    }
                    nodetypes.add(stringBuilder.toString());
                }
                catch (RepositoryException e) {}
            }
            json.put("paths", paths);
            json.put("nodetypes", nodetypes);
            json.put("size", uuids.size());
            return new ActionResult(200, null, json);
        }
        return ActionResult.OK;
    }
}

