/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions;

import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;

public class MultipleDeleteAction
extends Action {
    private static transient Logger logger = Logger.getLogger(MultipleDeleteAction.class);

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        List<String> uuids = parameters.get("uuids");
        assert (uuids != null && uuids.size() > 0);
        String mark = req.getParameter("markForDeletion");
        String comment = req.getParameter("markForDeletionComment");
        Boolean markForDeletion = mark != null && mark.length() > 0 ? Boolean.valueOf(mark) : null;
        try {
            for (String uuid : uuids) {
                JCRNodeWrapper node = session.getNodeByUUID(uuid);
                session.checkout((Node)node);
                if (markForDeletion == null) {
                    node.remove();
                    continue;
                }
                if (markForDeletion.booleanValue()) {
                    node.markForDeletion(comment);
                    continue;
                }
                node.unmarkForDeletion();
            }
            session.save();
        }
        catch (RepositoryException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return ActionResult.BAD_REQUEST;
        }
        return ActionResult.OK_JSON;
    }
}

