/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions;

import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.settings.SettingsBean;

public class MultiplePasteAction
extends Action {
    private static transient Logger logger = Logger.getLogger(MultiplePasteAction.class);

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        JCRNodeWrapper node;
        String targetPath;
        JCRNodeWrapper targetNode;
        List uuids = (List)req.getSession().getAttribute("org.jahia.uuids.to.copy");
        if (uuids != null && uuids.size() > 0) {
            targetNode = resource.getNode();
            targetPath = targetNode.getPath();
            try {
                for (String uuid : uuids) {
                    node = session.getNodeByUUID(uuid);
                    if (targetPath.startsWith(node.getPath())) continue;
                    session.checkout((Node)node);
                    node.copy(targetNode, JCRContentUtils.findAvailableNodeName((Node)targetNode, (String)node.getName()), true, null, SettingsBean.getInstance().getImportMaxBatch());
                }
                session.save();
            }
            catch (RepositoryException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return ActionResult.BAD_REQUEST;
            }
        }
        req.getSession().removeAttribute("org.jahia.uuids.to.copy");
        uuids = (List)req.getSession().getAttribute("org.jahia.uuids.to.cut");
        if (uuids != null && uuids.size() > 0) {
            targetNode = resource.getNode();
            targetPath = targetNode.getPath();
            try {
                for (String uuid : uuids) {
                    node = session.getNodeByUUID(uuid);
                    if (targetPath.startsWith(node.getPath())) continue;
                    session.checkout((Node)node);
                    session.move(node.getPath(), targetNode.getPath() + "/" + JCRContentUtils.findAvailableNodeName((Node)targetNode, (String)node.getName()));
                }
                session.save();
            }
            catch (RepositoryException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return ActionResult.BAD_REQUEST;
            }
        }
        req.getSession().removeAttribute("org.jahia.uuids.to.cut");
        return ActionResult.OK_JSON;
    }
}

