/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jahia.ajax.gwt.client.widget.publication.PublicationWorkflow;
import org.jahia.ajax.gwt.helper.PublicationHelper;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowVariable;
import org.jahia.utils.i18n.Messages;

public class MultiplePublishAction
extends Action {
    private WorkflowService workflowService;
    private PublicationHelper publicationHelper;

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setPublicationHelper(PublicationHelper publicationHelper) {
        this.publicationHelper = publicationHelper;
    }

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        List<String> uuids = parameters.get("uuids");
        LinkedHashSet<String> locales = new LinkedHashSet<String>(Arrays.asList(renderContext.getMainResourceLocale().toString()));
        List pubInfos = this.publicationHelper.getFullPublicationInfos(uuids, locales, session, false, false);
        if (pubInfos.size() == 0) {
            return ActionResult.BAD_REQUEST;
        }
        Map workflows = this.publicationHelper.createPublicationWorkflows(pubInfos);
        for (Map.Entry entry : workflows.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("customWorkflowInfo", entry.getKey());
            String title = Messages.getInternalWithArguments((String)"label.workflow.start.message", (Locale)session.getLocale(), (Object[])new Object[]{"{0} started by {1} on {2} - {3} content items involved", ((WorkflowDefinition)entry.getValue()).getDisplayName(), session.getUser().getName(), DateFormat.getDateInstance(3, session.getLocale()).format(new Date()), pubInfos.size()});
            WorkflowVariable var = new WorkflowVariable(title, 1);
            map.put("jcr:title", var);
            if (entry.getValue() == null) continue;
            this.workflowService.startProcessAsJob(((PublicationWorkflow)entry.getKey()).getAllUuids(), session, ((WorkflowDefinition)entry.getValue()).getKey(), ((WorkflowDefinition)entry.getValue()).getProvider(), map, null);
        }
        return ActionResult.OK_JSON;
    }
}

