/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.PublicationJob;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.scheduler.BackgroundJob;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;

public class PublishAction
extends Action {
    private JCRPublicationService publicationService;

    public void setPublicationService(JCRPublicationService publicationService) {
        this.publicationService = publicationService;
    }

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        Set<String> languages = null;
        if (session.getLocale() != null) {
            languages = Collections.singleton(session.getLocale().toString());
        }
        boolean withSubTree = true;
        if (parameters.get("withSubTree") != null) {
            String subTreeStr = parameters.get("withSubTree").get(0);
            withSubTree = Boolean.parseBoolean(subTreeStr);
        }
        boolean immediate = false;
        if (parameters.get("immediate") != null) {
            String immediateStr = parameters.get("immediate").get(0);
            immediate = Boolean.parseBoolean(immediateStr);
        }
        if (immediate) {
            this.publicationService.publishByMainId(resource.getNode().getIdentifier(), "default", "live", languages, withSubTree, new ArrayList());
        } else {
            JobDetail jobDetail = BackgroundJob.createJahiaJob((String)"Publication", PublicationJob.class);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            ArrayList<String> uuidList = new ArrayList<String>(1);
            uuidList.add(resource.getNode().getIdentifier());
            jobDataMap.put("userkey", renderContext.getUser().getUserKey());
            jobDataMap.put("sitekey", renderContext.getSite().getSiteKey());
            jobDataMap.put((Object)"publicationInfos", uuidList);
            jobDataMap.put("source", "default");
            jobDataMap.put("destination", "live");
            jobDataMap.put("checkPermissions", true);
            ServicesRegistry.getInstance().getSchedulerService().scheduleJobNow(jobDetail);
        }
        return ActionResult.OK_JSON;
    }
}

