/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.ActionResult;
import org.jahia.exceptions.JahiaException;
import org.jahia.modules.defaultmodule.actions.admin.AdminAction;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Url;
import org.jahia.utils.i18n.Messages;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminCreateSiteAction
extends AdminAction {
    private static Logger logger = LoggerFactory.getLogger(AdminCreateSiteAction.class);
    protected JahiaSitesService sitesService;

    public void setSitesService(JahiaSitesService sitesService) {
        this.sitesService = sitesService;
    }

    @Override
    public String getMessage(Locale locale, String key) {
        String message = Messages.get((String)"resources.JahiaServerSettings", (String)key, (Locale)locale);
        return StringUtils.isEmpty((String)message) ? super.getMessage(locale, key) : message;
    }

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        JCRNodeWrapper node = resource.getNode();
        if (!node.isNodeType("jnt:virtualsitesFolder") || !node.getPath().equals("/sites")) {
            return ActionResult.BAD_REQUEST;
        }
        logger.debug("started");
        String siteTitle = StringUtils.left((String)StringUtils.defaultString((String)AdminCreateSiteAction.getParameter(parameters, (String)"siteTitle")).trim(), (int)100);
        String siteServerName = StringUtils.left((String)StringUtils.defaultString((String)AdminCreateSiteAction.getParameter(parameters, (String)"siteServerName")).trim(), (int)200);
        String siteKey = StringUtils.left((String)StringUtils.defaultString((String)AdminCreateSiteAction.getParameter(parameters, (String)"siteKey")).trim(), (int)50);
        String siteDescr = StringUtils.left((String)StringUtils.defaultString((String)AdminCreateSiteAction.getParameter(parameters, (String)"siteDescr")).trim(), (int)250);
        HashMap<String, String> result = new HashMap<String, String>();
        JahiaSite site = null;
        try {
            if (siteTitle != null && siteTitle.length() > 0 && siteServerName != null && siteServerName.length() > 0 && siteKey != null && siteKey.length() > 0) {
                if (!this.sitesService.isSiteKeyValid(siteKey)) {
                    result.put("warn", this.getMessage(renderContext.getUILocale(), "serverSettings.manageWebProjects.warningMsg.onlyLettersDigitsUnderscore"));
                    return new ActionResult(200, null, new JSONObject(result));
                }
                if (siteKey.equals("site")) {
                    result.put("warn", this.getMessage(renderContext.getUILocale(), "serverSettings.manageWebProjects.warningMsg.chooseAnotherSiteKey"));
                    return new ActionResult(200, null, new JSONObject(result));
                }
                if (!this.sitesService.isServerNameValid(siteServerName)) {
                    result.put("warn", this.getMessage(renderContext.getUILocale(), "serverSettings.manageWebProjects.warningMsg.invalidServerName"));
                    return new ActionResult(200, null, new JSONObject(result));
                }
                if (siteServerName.equals("default")) {
                    result.put("warn", this.getMessage(renderContext.getUILocale(), "serverSettings.manageWebProjects.warningMsg.chooseAnotherServerName"));
                    return new ActionResult(200, null, new JSONObject(result));
                }
                if (!Url.isLocalhost((String)siteServerName) && this.sitesService.getSite(siteServerName) != null) {
                    result.put("warn", this.getMessage(renderContext.getUILocale(), "serverSettings.manageWebProjects.warningMsg.chooseAnotherServerName"));
                    return new ActionResult(200, null, new JSONObject(result));
                }
                if (this.sitesService.getSiteByKey(siteKey) != null) {
                    result.put("warn", this.getMessage(renderContext.getUILocale(), "serverSettings.manageWebProjects.warningMsg.chooseAnotherSiteKey"));
                    return new ActionResult(200, null, new JSONObject(result));
                }
            } else {
                result.put("warn", this.getMessage(renderContext.getUILocale(), "serverSettings.manageWebProjects.warningMsg.completeRequestInfo"));
                return new ActionResult(200, null, new JSONObject(result));
            }
            Locale selectedLocale = resource.getLocale();
            String lang = AdminCreateSiteAction.getParameter(parameters, (String)"language");
            if (lang != null) {
                selectedLocale = LanguageCodeConverters.getLocaleFromCode((String)lang);
            }
            site = this.sitesService.addSite(session.getUser(), siteTitle, siteServerName, siteKey, siteDescr, selectedLocale, AdminCreateSiteAction.getParameter(parameters, (String)"templatesSet"), null, null, null, null, Boolean.valueOf(false), null, null, null, null, session);
            if (AdminCreateSiteAction.getParameter(parameters, (String)"mixLanguage", (String)"false").equals("true") || AdminCreateSiteAction.getParameter(parameters, (String)"allowsUnlistedLanguages", (String)"false").equals("true")) {
                site.setMixLanguagesActive(AdminCreateSiteAction.getParameter(parameters, (String)"mixLanguage", (String)"false").equals("true"));
                site.setAllowsUnlistedLanguages(AdminCreateSiteAction.getParameter(parameters, (String)"allowsUnlistedLanguages", (String)"false").equals("true"));
                this.sitesService.updateSystemSitePermissions(site);
            }
            if (site != null) {
                JahiaSite systemSite = this.sitesService.getSiteByKey("systemsite");
                if (!systemSite.getLanguages().containsAll(site.getLanguages())) {
                    systemSite.getLanguages().addAll(site.getLanguages());
                    this.sitesService.updateSystemSitePermissions(systemSite);
                }
            } else {
                result.put("warn", this.getMessage(renderContext.getUILocale(), "label.error.processingRequestError"));
                return new ActionResult(200, null, new JSONObject(result));
            }
            session.save();
            this.configureSite(site, req, renderContext, resource, session, parameters, urlResolver);
        }
        catch (JahiaException ex) {
            try {
                if (site != null) {
                    this.sitesService.removeSite(site);
                }
            }
            catch (Exception t) {
                logger.error("Error while cleaning site", (Throwable)t);
            }
            logger.error("Error while adding site", (Throwable)ex);
            result.put("warn", this.getMessage(renderContext.getUILocale(), "label.error.processingRequestError"));
            return new ActionResult(200, null, new JSONObject(result));
        }
        return ActionResult.OK_JSON;
    }

    protected void configureSite(JahiaSite site, HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) {
    }
}

