/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.Node;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.ActionResult;
import org.jahia.exceptions.JahiaException;
import org.jahia.modules.defaultmodule.actions.admin.AdminSiteAction;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.sites.JahiaSite;
import org.jahia.utils.Url;
import org.jahia.utils.i18n.Messages;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminEditSiteAction
extends AdminSiteAction {
    private static Logger logger = LoggerFactory.getLogger(AdminEditSiteAction.class);

    @Override
    public String getMessage(Locale locale, String key) {
        String message = Messages.get((String)"resources.JahiaServerSettings", (String)key, (Locale)locale);
        return StringUtils.isEmpty((String)message) ? super.getMessage(locale, key) : message;
    }

    @Override
    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, JahiaSite site, JCRSessionWrapper session, Map<String, List<String>> parameters) throws Exception {
        logger.debug(" process edit site started ");
        String siteTitle = StringUtils.left((String)StringUtils.defaultString((String)AdminEditSiteAction.getParameter(parameters, (String)"siteTitle")).trim(), (int)100);
        String siteServerName = StringUtils.left((String)StringUtils.defaultString((String)AdminEditSiteAction.getParameter(parameters, (String)"siteServerName")).trim(), (int)200);
        String siteDescr = StringUtils.left((String)StringUtils.defaultString((String)AdminEditSiteAction.getParameter(parameters, (String)"siteDescr")).trim(), (int)250);
        boolean defaultSite = AdminEditSiteAction.getParameter(parameters, (String)"defaultSite") != null;
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            session.checkout((Node)site);
            if (siteTitle != null && siteTitle.trim().length() > 0 && siteServerName != null && siteServerName.trim().length() > 0) {
                if (!this.isServerNameValid(siteServerName)) {
                    result.put("warn", this.getMessage(renderContext.getUILocale(), "serverSettings.manageWebProjects.warningMsg.invalidServerName"));
                    return new ActionResult(200, null, new JSONObject(result));
                }
                if (!site.getServerName().equals(siteServerName) && !Url.isLocalhost((String)siteServerName) && this.sitesService.getSite(siteServerName) != null) {
                    result.put("warn", this.getMessage(renderContext.getUILocale(), "serverSettings.manageWebProjects.warningMsg.chooseAnotherServerName"));
                    return new ActionResult(200, null, new JSONObject(result));
                }
            } else {
                result.put("warn", this.getMessage(renderContext.getUILocale(), "serverSettings.manageWebProjects.warningMsg.completeRequestInfo"));
                return new ActionResult(200, null, new JSONObject(result));
            }
            site.setTitle(siteTitle);
            site.setServerName(siteServerName);
            site.setDescription(siteDescr);
            this.sitesService.updateSystemSitePermissions(site);
            JahiaSite defSite = this.sitesService.getDefaultSite();
            if (defaultSite) {
                if (defSite == null) {
                    this.sitesService.setDefaultSite(site);
                } else if (!defSite.getSiteKey().equals(site.getSiteKey())) {
                    this.sitesService.setDefaultSite(site);
                }
            } else if (defSite != null && defSite.getSiteKey().equals(site.getSiteKey())) {
                this.sitesService.setDefaultSite(null);
            }
            session.save();
            return ActionResult.OK_JSON;
        }
        catch (JahiaException ex) {
            logger.warn("Error while processing site edition", (Throwable)ex);
            result.put("warn", this.getMessage(renderContext.getUILocale(), "label.error.processingRequestError"));
            return new ActionResult(200, null, new JSONObject(result));
        }
    }

    public boolean isServerNameValid(String serverName) {
        return StringUtils.isNotEmpty((String)serverName) && !serverName.contains(" ") && !serverName.contains(":");
    }
}

