/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.defaultmodule.actions.admin;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.ActionResult;
import org.jahia.modules.defaultmodule.actions.admin.AdminAction;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;

public abstract class AdminSiteAction
extends AdminAction {
    protected JahiaSitesService sitesService;

    public void setSitesService(JahiaSitesService sitesService) {
        this.sitesService = sitesService;
    }

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        List<String> sites = parameters.get("sitebox");
        if (sites == null) {
            JCRNodeWrapper node = resource.getNode();
            if (!node.isNodeType("jnt:virtualsite") || !node.getParent().getPath().equals("/sites")) {
                return ActionResult.BAD_REQUEST;
            }
            JCRSiteNode site = this.sitesService.getSiteByKey(node.getName(), session);
            return this.doExecute(req, renderContext, (JahiaSite)site, session, parameters);
        }
        JCRNodeWrapper node = resource.getNode();
        if (!node.isNodeType("jnt:virtualsitesFolder") || !node.getPath().equals("/sites")) {
            return ActionResult.BAD_REQUEST;
        }
        for (String site : sites) {
            this.doExecute(req, renderContext, this.sitesService.getSiteByKey(site), session, parameters);
        }
        return ActionResult.OK_JSON;
    }

    public abstract ActionResult doExecute(HttpServletRequest var1, RenderContext var2, JahiaSite var3, JCRSessionWrapper var4, Map<String, List<String>> var5) throws Exception;
}

