/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.templates.JahiaModuleAware;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;

public class JahiaModuleConfigRegistry
implements JahiaModuleAware {
    private JahiaTemplatesPackage module;
    private ManagedService managedService;
    private ManagedServiceFactory managedServiceFactory;
    private ServiceRegistration serviceRegistration;

    public void start() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (this.managedService != null) {
            ((Dictionary)props).put("service.pid", this.managedService.getClass().getName());
            this.serviceRegistration = this.module.getBundle().getBundleContext().registerService(ManagedService.class.getName(), (Object)this.managedService, props);
        } else if (this.managedServiceFactory != null) {
            ((Dictionary)props).put("service.pid", this.managedServiceFactory.getName());
            this.serviceRegistration = this.module.getBundle().getBundleContext().registerService(ManagedServiceFactory.class.getName(), (Object)this.managedServiceFactory, props);
        }
    }

    public void stop() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    public void setJahiaModule(JahiaTemplatesPackage module) {
        this.module = module;
    }

    public void setManagedService(ManagedService managedService) {
        this.managedService = managedService;
    }

    public void setManagedServiceFactory(ManagedServiceFactory managedServiceFactory) {
        this.managedServiceFactory = managedServiceFactory;
    }
}

