/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.dm.viewer;

import javax.jcr.RepositoryException;
import org.drools.core.spi.KnowledgeHelper;
import org.jahia.dm.viewer.DocumentViewerService;
import org.jahia.services.content.rules.AddedNodeFact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentViewerRuleService {
    private static Logger logger = LoggerFactory.getLogger(DocumentViewerRuleService.class);
    private DocumentViewerService viewerService;

    public void createView(AddedNodeFact nodeFact, KnowledgeHelper drools) throws RepositoryException {
        if (this.viewerService == null || !this.viewerService.isEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Documen SWF view generation service is not enabled. Skipping generation for node {}", (Object)nodeFact.getPath());
            }
            return;
        }
        try {
            this.viewerService.createViewForNode(nodeFact.getNode());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setDocumentViewerService(DocumentViewerService service) {
        this.viewerService = service;
    }
}

