/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.dm.viewer.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.version.Version;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.value.BinaryImpl;
import org.jahia.dm.DocumentOperationException;
import org.jahia.dm.viewer.DocumentViewerService;
import org.jahia.modules.dm.viewer.impl.PDF2SWFConverterService;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.transform.DocumentConverterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentViewerServiceImpl
implements DocumentViewerService {
    private static final Logger logger = LoggerFactory.getLogger(DocumentViewerServiceImpl.class);
    private DocumentConverterService documentConverter;
    private PDF2SWFConverterService pdf2SWFConverter;
    private String[] supportedDocumentFormats;

    public boolean canHandle(JCRNodeWrapper fileNode) throws RepositoryException {
        if (!this.isEnabled() || this.supportedDocumentFormats == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Document viewer service is disabled" + (this.supportedDocumentFormats == null ? " as no supported document formats are configured" : "") + ". Skip converting node {}", (Object)fileNode.getPath());
            }
            return false;
        }
        return fileNode.isNodeType("nt:file") && JCRContentUtils.isMimeTypeGroup((String)fileNode.getFileContent().getContentType(), (String[])this.supportedDocumentFormats);
    }

    public File convert(File inputPdfFile) throws DocumentOperationException {
        return this.pdf2SWFConverter.convert(inputPdfFile);
    }

    public boolean convert(File inputPdfFile, File outputSwfFile) throws DocumentOperationException {
        return this.pdf2SWFConverter.convert(inputPdfFile, outputSwfFile);
    }

    public OutputStream convert(InputStream inputPdfStream) throws DocumentOperationException {
        return this.pdf2SWFConverter.convert(inputPdfStream);
    }

    public boolean convert(InputStream inputPdfStream, OutputStream outputSwfStream) throws DocumentOperationException {
        return this.pdf2SWFConverter.convert(inputPdfStream, outputSwfStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createPdfViewForNode(JCRNodeWrapper fileNode) throws RepositoryException, DocumentOperationException {
        if (!this.isEnabled() || !this.documentConverter.isEnabled()) {
            logger.info("Viewer service is disabled. Skip converting node {}", (Object)fileNode.getPath());
            return false;
        }
        long timer = System.currentTimeMillis();
        if (fileNode.isNodeType("nt:file")) {
            File outFile = null;
            try {
                outFile = this.getAsPDF(fileNode);
                if (outFile == null) return true;
                fileNode.getSession().checkout((Node)fileNode);
                JCRNodeWrapper pdfNode = null;
                try {
                    pdfNode = fileNode.getNode("pdfView");
                }
                catch (PathNotFoundException e) {
                    if (!fileNode.isNodeType("jmix:pdfDocumentView")) {
                        fileNode.addMixin("jmix:pdfDocumentView");
                    }
                    pdfNode = fileNode.addNode("pdfView", "nt:resource");
                }
                BufferedInputStream convertedStream = new BufferedInputStream(new FileInputStream(outFile));
                try {
                    if (pdfNode.hasProperty("jcr:data")) {
                        pdfNode.getProperty("jcr:data").remove();
                    }
                    pdfNode.setProperty("jcr:data", (Binary)new BinaryImpl((InputStream)convertedStream));
                    pdfNode.setProperty("jcr:mimeType", "application/pdf");
                    Calendar lastModified = Calendar.getInstance();
                    pdfNode.setProperty("jcr:lastModified", lastModified);
                    fileNode.getSession().save();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)convertedStream);
                }
                if (!logger.isDebugEnabled()) return true;
                logger.debug("Created PDF view for node {} in {} ms", (Object)fileNode.getPath(), (Object)(System.currentTimeMillis() - timer));
                return true;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return true;
            }
            finally {
                FileUtils.deleteQuietly((File)outFile);
            }
        }
        logger.warn("Path should correspond to a file node. Skipping node {}", (Object)fileNode.getPath());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean createViewForNode(JCRNodeWrapper fileNode) throws RepositoryException, DocumentOperationException {
        if (!this.isEnabled() || this.supportedDocumentFormats == null) {
            DocumentViewerServiceImpl.logger.info("Viewer service is disabled" + (this.supportedDocumentFormats == null ? " as no supported document formats are configured" : "") + ". Skip converting node {}", (Object)fileNode.getPath());
            return false;
        }
        timer = System.currentTimeMillis();
        if (fileNode.isNodeType("nt:file") && JCRContentUtils.isMimeTypeGroup((String)fileNode.getFileContent().getContentType(), (String[])this.supportedDocumentFormats)) {
            sourceContentType = fileNode.getFileContent().getContentType();
            inFile = null;
            sourceAvailable = true;
            try {
                if (JCRContentUtils.isMimeTypeGroup((String)sourceContentType, (String)"pdf")) {
                    inFile = File.createTempFile("doc-viewer-source", null);
                    JCRContentUtils.downloadFileContent((JCRNodeWrapper)fileNode, (File)inFile);
                } else {
                    inFile = this.getAsPDF(fileNode);
                }
                ** if (sourceAvailable) goto lbl-1000
            }
            catch (IOException e) {
                try {
                    DocumentViewerServiceImpl.logger.error(e.getMessage(), (Throwable)e);
                    sourceAvailable = false;
                    ** if (sourceAvailable) goto lbl-1000
                }
                catch (Throwable var8_8) {
                    if (!sourceAvailable) {
                        FileUtils.deleteQuietly(inFile);
                    }
                    throw var8_8;
                }
lbl-1000:
                // 1 sources

                {
                    FileUtils.deleteQuietly((File)inFile);
                }
lbl-1000:
                // 2 sources

                {
                }
            }
lbl-1000:
            // 1 sources

            {
                FileUtils.deleteQuietly((File)inFile);
            }
lbl-1000:
            // 2 sources

            {
            }
            if (inFile == null) {
                return false;
            }
            outFile = null;
            try {
                outFile = this.pdf2SWFConverter.convert(inFile);
                if (outFile == null) ** GOTO lbl96
                fileNode.getSession().checkout((Node)fileNode);
                swfNode = null;
                try {
                    swfNode = fileNode.getNode("swfView");
                }
                catch (PathNotFoundException e) {
                    if (!fileNode.isNodeType("jmix:swfDocumentView")) {
                        fileNode.addMixin("jmix:swfDocumentView");
                    }
                    swfNode = fileNode.addNode("swfView", "nt:resource");
                }
                convertedStream = new BufferedInputStream(new FileInputStream(outFile));
                try {
                    if (swfNode.hasProperty("jcr:data")) {
                        swfNode.getProperty("jcr:data").remove();
                    }
                    swfNode.setProperty("jcr:data", (Binary)new BinaryImpl((InputStream)convertedStream));
                    swfNode.setProperty("jcr:mimeType", "application/x-shockwave-flash");
                    lastModified = Calendar.getInstance();
                    swfNode.setProperty("jcr:lastModified", lastModified);
                    fileNode.getSession().save();
                    vm = fileNode.getSession().getWorkspace().getVersionManager();
                    vi = vm.getVersionHistory(fileNode.getPath()).getAllLinearVersions();
                    current = null;
                    while (vi.hasNext()) {
                        current = (Version)vi.next();
                    }
                    if (current != null) {
                        label = null;
                        for (String l : vm.getVersionHistory(fileNode.getPath()).getVersionLabels(current)) {
                            if (!l.startsWith(fileNode.getSession().getWorkspace().getName() + "_uploaded_at_")) continue;
                            label = l;
                            break;
                        }
                        if (label != null) {
                            v = vm.checkpoint(fileNode.getPath());
                            vm.getVersionHistory(fileNode.getPath()).addVersionLabel(v.getName(), label, true);
                        }
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)convertedStream);
                }
                if (!DocumentViewerServiceImpl.logger.isDebugEnabled()) ** GOTO lbl96
                DocumentViewerServiceImpl.logger.debug("Created SWF view for node {} in {} ms", (Object)fileNode.getPath(), (Object)(System.currentTimeMillis() - timer));
            }
            catch (LockException e) {
                DocumentViewerServiceImpl.logger.warn("Document preview cannot be generated because this node is locked (or archived): " + fileNode.toString());
            }
            catch (Exception e) {
                DocumentViewerServiceImpl.logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                FileUtils.deleteQuietly((File)inFile);
                FileUtils.deleteQuietly((File)outFile);
            }
        } else {
            DocumentViewerServiceImpl.logger.warn("Path should correspond to a file node with one of the supported formats {}. Skipping node {}", (Object)this.supportedDocumentFormats, (Object)fileNode.getPath());
        }
lbl96:
        // 6 sources

        return true;
    }

    protected File getAsPDF(JCRNodeWrapper fileNode) {
        if (this.documentConverter == null || !this.documentConverter.isEnabled()) {
            logger.info("Document converter service is not enabled. Cannot convert document {} into a PDF. Skip creating SWF view.", (Object)fileNode.getPath());
            return null;
        }
        File pdf = null;
        long timer = System.currentTimeMillis();
        File inFile = null;
        try {
            inFile = File.createTempFile("doc-viewer-source", null);
            JCRContentUtils.downloadFileContent((JCRNodeWrapper)fileNode, (File)inFile);
            pdf = this.documentConverter.convert(inFile, fileNode.getFileContent().getContentType(), "application/pdf");
        }
        catch (IOException e) {
            throw new DocumentOperationException("Error occurred downloading the source document " + fileNode.getPath() + " into a temporary file " + inFile + " for generating an SWF view", (Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)inFile);
            if (pdf != null && logger.isDebugEnabled()) {
                logger.debug("Converted document {} into a PDF file in {} ms", (Object)fileNode.getPath(), (Object)(System.currentTimeMillis() - timer));
            }
        }
        return pdf;
    }

    public boolean isEnabled() {
        return this.pdf2SWFConverter != null && this.pdf2SWFConverter.isEnabled();
    }

    public void setDocumentConverter(DocumentConverterService documentConverter) {
        this.documentConverter = documentConverter;
    }

    public void setPDF2SWFConverter(PDF2SWFConverterService service) {
        this.pdf2SWFConverter = service;
    }

    public void setSupportedDocumentFormats(String[] supportedDocumentFormats) {
        this.supportedDocumentFormats = supportedDocumentFormats;
    }
}

