/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.dm.viewer.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jahia.dm.DocumentOperationException;
import org.jahia.dm.utils.ProcessUtils;
import org.jahia.utils.StringOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class PDF2SWFConverterService
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(PDF2SWFConverterService.class);
    private boolean autodetect;
    private boolean enabled;
    private String executablePath = "pdf2swf";
    private String parameters = "${input} -o ${output} -f -T 9 -t -s storeallcharacters";
    private File workingDir;

    public void afterPropertiesSet() throws Exception {
        if (this.autodetect) {
            this.doAutodetect();
        }
    }

    public File convert(File inputPdfFile) throws DocumentOperationException {
        if (!this.isEnabled()) {
            logger.info("pdf2swf conversion service is not enabled. Skip converting file {}", (Object)inputPdfFile);
            return null;
        }
        File out = null;
        try {
            out = this.createTempFile();
            this.convert(inputPdfFile, out);
        }
        catch (DocumentOperationException e) {
            FileUtils.deleteQuietly((File)out);
            throw e;
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)out);
            logger.error("Unable to create a temp file for document conversion operation. Cause: " + e.getMessage(), (Throwable)e);
        }
        return out;
    }

    public boolean convert(File inputPdfFile, File outputSwfFile) throws DocumentOperationException {
        if (!this.isEnabled()) {
            logger.info("pdf2swf conversion service is not enabled. Skip converting file {}", (Object)inputPdfFile);
            return false;
        }
        long timer = System.currentTimeMillis();
        CommandLine cmd = this.getConvertCommandLine(inputPdfFile, outputSwfFile);
        if (logger.isDebugEnabled()) {
            logger.debug("Execuiting conversion command: {}", (Object)cmd.toString());
        }
        int exitValue = 0;
        StringOutputStream out = new StringOutputStream();
        StringOutputStream err = new StringOutputStream();
        try {
            DefaultExecutor executor = new DefaultExecutor();
            executor.setStreamHandler(new PumpStreamHandler((OutputStream)out, (OutputStream)err));
            if (this.workingDir != null && (this.workingDir.exists() || this.workingDir.mkdirs())) {
                executor.setWorkingDirectory(this.workingDir);
            }
            exitValue = executor.execute(cmd, System.getenv());
        }
        catch (Exception e) {
            throw new DocumentOperationException((Throwable)e);
        }
        finally {
            if (err.getLength() > 0) {
                logger.error("Conversion process finished with error. Cause: {}", (Object)err.toString());
            }
            if (logger.isDebugEnabled() && out.getLength() > 0) {
                logger.debug(out.toString());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Conversion from {} to {} done (exit code: {}) in {} ms", new Object[]{inputPdfFile, outputSwfFile, exitValue, System.currentTimeMillis() - timer});
        }
        return exitValue == 0;
    }

    public OutputStream convert(InputStream inputPdfStream) throws DocumentOperationException {
        if (!this.isEnabled()) {
            logger.info("pdf2swf conversion service is not enabled. Skip converting file input stream.");
            return null;
        }
        File in = null;
        File out = null;
        try {
            in = this.createTempFile();
            FileUtils.copyInputStreamToFile((InputStream)inputPdfStream, (File)in);
            out = this.createTempFile();
            this.convert(in, out);
        }
        catch (Exception e) {
            FileUtils.deleteQuietly(out);
            throw new DocumentOperationException((Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)in);
        }
        BufferedOutputStream os = null;
        if (out != null) {
            try {
                os = new BufferedOutputStream(new FileOutputStream(out));
            }
            catch (FileNotFoundException e) {
                throw new DocumentOperationException((Throwable)e);
            }
        }
        return os;
    }

    public boolean convert(InputStream inputPdfStream, OutputStream outputSwfStream) throws DocumentOperationException {
        if (!this.isEnabled()) {
            logger.info("pdf2swf conversion service is not enabled. Skip converting file input stream.");
            return false;
        }
        File in = null;
        File out = null;
        try {
            in = this.createTempFile();
            FileUtils.copyInputStreamToFile((InputStream)inputPdfStream, (File)in);
            out = this.createTempFile();
            this.convert(in, out);
        }
        catch (Exception e) {
            FileUtils.deleteQuietly(out);
            throw new DocumentOperationException((Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)in);
        }
        if (out != null) {
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(out));
                IOUtils.copy((InputStream)is, (OutputStream)outputSwfStream);
            }
            catch (IOException e) {
                try {
                    throw new DocumentOperationException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    FileUtils.deleteQuietly((File)out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            FileUtils.deleteQuietly((File)out);
        }
        return true;
    }

    protected File createTempFile() throws IOException {
        return File.createTempFile("doc-viewer", null);
    }

    protected void doAutodetect() {
        logger.info("Checking if the {} is present in the current path", (Object)this.executablePath);
        this.enabled = ProcessUtils.commandPresent((String)this.executablePath, (File)this.workingDir);
        if (this.enabled) {
            logger.info("Found {} in the current system path. Service will be enabled.", (Object)this.executablePath);
        } else {
            logger.info("Command {} cannot be found in the current system path. The service will be disabled.", (Object)this.executablePath);
        }
    }

    protected CommandLine getConvertCommandLine(File inputFile, File outputFile) {
        CommandLine cmd = new CommandLine(this.executablePath);
        cmd.addArguments(this.parameters);
        HashMap<String, File> params = new HashMap<String, File>(2);
        params.put("input", inputFile);
        params.put("output", outputFile);
        cmd.setSubstitutionMap(params);
        return cmd;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setActivate(String activate) {
        activate = activate != null ? activate.trim() : activate;
        this.enabled = Boolean.valueOf(activate);
        if (!this.enabled && activate != null) {
            this.autodetect = "auto".equalsIgnoreCase(activate) || "autodetect".equalsIgnoreCase(activate);
        }
    }

    public void setExecutablePath(String executablePath) {
        this.executablePath = executablePath;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }
}

