/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import javax.jcr.version.VersionException;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.jaas.JahiaPrincipal;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.modules.external.ExternalDataSource;
import org.jahia.modules.external.ExternalNodeImpl;
import org.jahia.modules.external.ExternalPathWrapperImpl;
import org.jahia.modules.external.ExternalSessionImpl;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.security.AccessManagerUtils;
import org.jahia.utils.security.PathWrapper;

public class ExternalAccessControlManager
implements AccessControlManager {
    private static final AccessControlPolicy[] POLICIES = new AccessControlPolicy[0];
    private static final String SYSTEM_USER = " system ";
    private Map<String, Boolean> pathPermissionCache = null;
    private Map<Object, AccessManagerUtils.CompiledAcl> compiledAcls = new HashMap<Object, AccessManagerUtils.CompiledAcl>();
    private JahiaPrivilegeRegistry registry;
    private final ExternalSessionImpl session;
    private final String workspaceName;
    private final JahiaPrincipal jahiaPrincipal;
    private final boolean aclReadOnly;
    private final boolean writable;
    private final Privilege modifyAccessControlPrivilege;
    private final Privilege writePrivilege;
    private final String rootUserName;
    private final boolean supportPrivileges;
    private final ExternalDataSource dataSource;

    public ExternalAccessControlManager(NamespaceRegistry namespaceRegistry, ExternalSessionImpl session, ExternalDataSource dataSource) {
        this.session = session;
        this.workspaceName = session.getWorkspace().getName();
        this.aclReadOnly = dataSource instanceof ExternalDataSource.AccessControllable || dataSource instanceof ExternalDataSource.SupportPrivileges;
        this.writable = dataSource instanceof ExternalDataSource.Writable;
        this.supportPrivileges = dataSource instanceof ExternalDataSource.SupportPrivileges;
        this.rootUserName = JahiaUserManagerService.getInstance().getRootUserName();
        this.dataSource = dataSource;
        this.pathPermissionCache = Collections.synchronizedMap(new LRUMap(SettingsBean.getInstance().getAccessManagerPathPermissionCacheMaxSize()));
        this.jahiaPrincipal = new JahiaPrincipal(session.getUserID(), session.getRealm(), session.getUserID().startsWith(SYSTEM_USER), " guest ".equals(session.getUserID()));
        try {
            this.registry = new JahiaPrivilegeRegistry(namespaceRegistry);
            this.modifyAccessControlPrivilege = this.registry.getPrivilege("jcr:modifyAccessControl", this.workspaceName);
            this.writePrivilege = this.registry.getPrivilege("jcr:write", this.workspaceName);
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        return AccessControlPolicyIteratorAdapter.EMPTY;
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        return POLICIES;
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        return POLICIES;
    }

    public Privilege[] getSupportedPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        return JahiaPrivilegeRegistry.getRegisteredPrivileges();
    }

    public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        JCRNodeWrapper node = JCRSessionFactory.getInstance().getCurrentSystemSession(this.workspaceName, null, null).getNode(this.session.getRepository().getStoreProvider().getMountPoint() + absPath);
        Privilege[] privileges = this.supportPrivileges ? this.getPrivilegesLegacy(absPath) : AccessManagerUtils.getPrivileges((Node)node, (JahiaPrincipal)this.jahiaPrincipal, (JahiaPrivilegeRegistry)this.registry);
        List<Privilege> privilegeToFilter = this.getPrivilegesToFilter(node.getRealNode());
        if (privilegeToFilter.size() > 0) {
            return ExternalAccessControlManager.filterPrivileges(privileges, privilegeToFilter);
        }
        return privileges;
    }

    public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        HashSet<String> privs = new HashSet<String>();
        for (Privilege privilege : privileges) {
            privs.add(privilege.getName());
        }
        String mountPoint = this.session.getRepository().getStoreProvider().getMountPoint();
        ExternalSessionImpl securitySession = this.session.getUserID().startsWith(SYSTEM_USER) ? this.session : JCRSessionFactory.getInstance().getCurrentSystemSession(this.session.getWorkspace().getName(), null, null);
        ExternalPathWrapperImpl pathWrapper = new ExternalPathWrapperImpl(StringUtils.equals((String)absPath, (String)"/") ? mountPoint : mountPoint + absPath, securitySession);
        boolean isGranted = AccessManagerUtils.isGranted((PathWrapper)pathWrapper, privs, (Session)securitySession, (JahiaPrincipal)this.jahiaPrincipal, (String)this.workspaceName, (boolean)false, this.pathPermissionCache, this.compiledAcls, (JahiaPrivilegeRegistry)this.registry);
        if (this.supportPrivileges) {
            for (Item item : this.session.getNewItems()) {
                if (!item.getPath().equals(absPath)) continue;
                return true;
            }
            isGranted = isGranted && this.hasPrivilegesLegacy(absPath, privileges);
        }
        return isGranted;
    }

    private Privilege[] getPrivilegesLegacy(String absPath) throws PathNotFoundException, RepositoryException {
        ArrayList<Privilege> l = new ArrayList<Privilege>();
        for (String s : this.getPrivilegesNamesLegacy(absPath)) {
            Privilege privilege = this.registry.getPrivilege(s, null);
            if (privilege == null) continue;
            l.add(privilege);
        }
        return l.toArray(new Privilege[l.size()]);
    }

    private String[] getPrivilegesNamesLegacy(String absPath) {
        ExternalContentStoreProvider.setCurrentSession(this.session);
        try {
            String[] stringArray = ((ExternalDataSource.SupportPrivileges)((Object)this.dataSource)).getPrivilegesNames(this.session.getUserID(), absPath);
            return stringArray;
        }
        finally {
            ExternalContentStoreProvider.removeCurrentSession();
        }
    }

    private boolean hasPrivilegesLegacy(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        if (privileges == null || privileges.length == 0) {
            return true;
        }
        String userID = this.session.getUserID();
        if (userID.startsWith(SYSTEM_USER) || this.rootUserName.equals(userID)) {
            return true;
        }
        boolean allowed = true;
        Object[] granted = this.getPrivileges(absPath);
        for (Privilege toCheck : privileges) {
            if (toCheck == null || ArrayUtils.contains((Object[])granted, (Object)toCheck)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    public Privilege privilegeFromName(String privilegeName) throws AccessControlException, RepositoryException {
        try {
            return this.registry.getPrivilege(privilegeName, null);
        }
        catch (AccessControlException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Unknown privilege {http://www.jcp.org/jcr/1.0}")) {
                return this.registry.getPrivilege(privilegeName, "default");
            }
            throw e;
        }
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, LockException, VersionException, RepositoryException {
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, LockException, VersionException, RepositoryException {
    }

    public void checkRead(String path) throws RepositoryException {
        if (!this.hasPrivileges(path, new Privilege[]{this.registry.getPrivilege("{http://www.jcp.org/jcr/1.0}read_" + this.session.getWorkspace().getName(), null)})) {
            throw new PathNotFoundException(path);
        }
    }

    public void checkModify(String path) throws RepositoryException {
        if (!this.hasPrivileges(path, new Privilege[]{this.registry.getPrivilege("{http://www.jcp.org/jcr/1.0}modifyProperties_" + this.session.getWorkspace().getName(), null)})) {
            throw new AccessDeniedException(path);
        }
    }

    public void checkAddChildNodes(String path) throws RepositoryException {
        if (!this.hasPrivileges(path, new Privilege[]{this.registry.getPrivilege("{http://www.jcp.org/jcr/1.0}addChildNodes_" + this.session.getWorkspace().getName(), null)})) {
            throw new AccessDeniedException(path);
        }
    }

    public void checkRemoveNode(String path) throws RepositoryException {
        if (!this.hasPrivileges(path, new Privilege[]{this.registry.getPrivilege("{http://www.jcp.org/jcr/1.0}removeNode_" + this.session.getWorkspace().getName(), null)})) {
            throw new AccessDeniedException(path);
        }
    }

    public boolean canManageNodeTypes(String path) throws RepositoryException {
        return this.hasPrivileges(path, new Privilege[]{this.registry.getPrivilege("{http://www.jcp.org/jcr/1.0}nodeTypeManagement_" + this.session.getWorkspace().getName(), null)});
    }

    private List<Privilege> getPrivilegesToFilter(Node node) {
        if (node instanceof JCRNodeWrapper) {
            node = ((JCRNodeWrapper)node).getRealNode();
        }
        ArrayList<Privilege> privilegeToFilterOut = new ArrayList<Privilege>();
        if (this.aclReadOnly && node instanceof ExternalNodeImpl) {
            privilegeToFilterOut.add(this.modifyAccessControlPrivilege);
        }
        if (!this.writable && node instanceof ExternalNodeImpl && (this.session.getOverridableProperties() == null || this.session.getOverridableProperties().size() == 0)) {
            privilegeToFilterOut.add(this.writePrivilege);
            privilegeToFilterOut.addAll(Lists.newArrayList((Object[])this.writePrivilege.getAggregatePrivileges()));
        }
        return privilegeToFilterOut;
    }

    private static Privilege[] filterPrivileges(Privilege[] privileges, List<Privilege> privilegesToFilterOut) {
        HashSet<Privilege> filteredResult = new HashSet<Privilege>();
        for (Privilege privilege : privileges) {
            if (privilegesToFilterOut.contains(privilege)) continue;
            if (privilege.isAggregate() && ExternalAccessControlManager.areIntersecting(privilege.getDeclaredAggregatePrivileges(), privilegesToFilterOut)) {
                filteredResult.addAll(Arrays.asList(ExternalAccessControlManager.filterPrivileges(privilege.getDeclaredAggregatePrivileges(), privilegesToFilterOut)));
                continue;
            }
            filteredResult.add(privilege);
        }
        return filteredResult.toArray(new Privilege[filteredResult.size()]);
    }

    private static boolean areIntersecting(Privilege[] privileges1, List<Privilege> privileges2) {
        for (Privilege privilege1 : privileges1) {
            if (!privileges2.contains(privilege1)) continue;
            return true;
        }
        return false;
    }
}

