/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.jackrabbit.value.BinaryImpl;
import org.jahia.modules.external.ExternalItemImpl;
import org.jahia.modules.external.ExternalNodeImpl;
import org.jahia.modules.external.ExternalSessionImpl;
import org.jahia.services.content.nodetypes.Name;

public class ExternalPropertyImpl
extends ExternalItemImpl
implements Property {
    private ExternalNodeImpl node;
    private Name name;
    private Value[] values;
    private Value value;

    public ExternalPropertyImpl(Name name, ExternalNodeImpl node, ExternalSessionImpl session, Value value) throws RepositoryException {
        super(session);
        this.name = name;
        this.node = node;
        this.value = value;
    }

    public ExternalPropertyImpl(Name name, ExternalNodeImpl node, ExternalSessionImpl session, Value[] values) throws RepositoryException {
        super(session);
        this.name = name;
        this.node = node;
        this.values = values;
    }

    public ExternalPropertyImpl(Name name, ExternalNodeImpl node, ExternalSessionImpl session) throws RepositoryException {
        super(session);
        this.name = name;
        this.node = node;
    }

    public void setValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.value = value;
    }

    public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkModify();
        this.values = values;
    }

    public void setValue(String s) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (s != null) {
            this.setValue(this.getSession().getValueFactory().createValue(s, this.getType()));
        } else {
            this.remove();
        }
    }

    public void setValue(String[] strings) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (strings != null) {
            Value[] v = new Value[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                v[i] = strings[i] != null ? this.getSession().getValueFactory().createValue(strings[i], this.getType()) : null;
            }
            this.setValue(v);
        } else {
            this.remove();
        }
    }

    public void setValue(Binary[] binaries) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (binaries != null) {
            Value[] v = new Value[binaries.length];
            for (int i = 0; i < binaries.length; ++i) {
                v[i] = binaries[i] != null ? this.getSession().getValueFactory().createValue(binaries[i]) : null;
            }
            this.setValue(v);
        } else {
            this.remove();
        }
    }

    public void setValue(InputStream inputStream) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (inputStream != null) {
            BinaryImpl b = null;
            try {
                b = new BinaryImpl(inputStream);
                this.setValue(this.getSession().getValueFactory().createValue((Binary)b));
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            finally {
                if (b != null) {
                    b.dispose();
                }
            }
        } else {
            this.remove();
        }
    }

    public void setValue(long l) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(l));
    }

    public void setValue(double v) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(v));
    }

    public void setValue(Calendar calendar) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (calendar != null) {
            this.setValue(this.getSession().getValueFactory().createValue(calendar));
        } else {
            this.remove();
        }
    }

    public void setValue(boolean b) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(b));
    }

    public void setValue(Node node) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Value getValue() throws ValueFormatException, RepositoryException {
        this.checkRead();
        if (this.isMultiple()) {
            throw new ValueFormatException(this.getName() + " is a multi-valued property, so it's values can only be retrieved as an array");
        }
        return this.value;
    }

    public void setValue(BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value != null) {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        } else {
            this.remove();
        }
    }

    public Value[] getValues() throws ValueFormatException, RepositoryException {
        this.checkRead();
        if (!this.isMultiple()) {
            throw new ValueFormatException(this.getName() + " is a single-valued property, so it's value can not be retrieved as an array");
        }
        return this.values;
    }

    public String getString() throws ValueFormatException, RepositoryException {
        this.checkRead();
        if (this.value != null) {
            return this.value.getString();
        }
        return null;
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        this.checkRead();
        if (this.value != null) {
            final Binary binary = this.value.getBinary();
            return new AutoCloseInputStream(binary.getStream()){

                public void close() throws IOException {
                    super.close();
                    binary.dispose();
                }
            };
        }
        return null;
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        this.checkRead();
        if (this.value != null) {
            return this.value.getLong();
        }
        return 0L;
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        this.checkRead();
        if (this.value != null) {
            return this.value.getDouble();
        }
        return 0.0;
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        this.checkRead();
        if (this.value != null) {
            return this.value.getDate();
        }
        return null;
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        this.checkRead();
        return this.value != null && this.value.getBoolean();
    }

    public Node getNode() throws ValueFormatException, RepositoryException {
        return null;
    }

    public long getLength() throws ValueFormatException, RepositoryException {
        return this.getLength(this.getValue());
    }

    protected long getLength(Value value) throws ValueFormatException, RepositoryException {
        return 2 == value.getType() ? value.getBinary().getSize() : (long)value.getString().length();
    }

    public long[] getLengths() throws ValueFormatException, RepositoryException {
        long[] lengths = new long[this.getValues().length];
        for (int i = 0; i < this.values.length; ++i) {
            lengths[i] = this.getLength(this.values[i]);
        }
        return lengths;
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        return this.node.getPropertyDefinition(this.getName());
    }

    public int getType() throws RepositoryException {
        return this.getDefinition().getRequiredType();
    }

    public void setValue(Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value != null) {
            if (this.getBinary() != null) {
                this.getBinary().dispose();
            }
            this.setValue(this.getSession().getValueFactory().createValue(value));
        } else {
            this.remove();
        }
    }

    public Binary getBinary() throws ValueFormatException, RepositoryException {
        return this.value.getBinary();
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        return this.value.getDecimal();
    }

    public Property getProperty() throws ItemNotFoundException, ValueFormatException, RepositoryException {
        return this;
    }

    public boolean isMultiple() throws RepositoryException {
        return this.values != null;
    }

    public String getPath() throws RepositoryException {
        return this.getParent().getPath() + "/" + this.name;
    }

    public String getName() throws RepositoryException {
        return this.name.toString();
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.node;
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        ((ExternalNodeImpl)this.getParent()).removeProperty(this.getName());
    }
}

