/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.jahia.modules.external.ExternalProviderInitializerService;
import org.jahia.services.content.DefaultEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountPointListener
extends DefaultEventListener {
    private static final Logger logger = LoggerFactory.getLogger(MountPointListener.class);
    private ExternalProviderInitializerService externalProviderInitializerService;

    public MountPointListener() {
        this.setWorkspace("default");
    }

    public int getEventTypes() {
        return 2;
    }

    public String getPath() {
        return "/mounts";
    }

    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            Event evt = events.nextEvent();
            try {
                this.externalProviderInitializerService.removeProvider(evt.getIdentifier());
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setExternalProviderInitializerService(ExternalProviderInitializerService mappingService) {
        this.externalProviderInitializerService = mappingService;
    }
}

