/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.admin.mount.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRMountPointNode;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class MountPoint
implements Serializable {
    private static final long serialVersionUID = 4618846382714016491L;
    private static Logger logger = LoggerFactory.getLogger(MountPoint.class);
    String name;
    String realName;
    String path;
    String displayStatusClass;
    JCRMountPointNode.MountStatus status;
    String identifier;
    String nodetype;
    Map<String, String> mountPointProperties;
    boolean showMountAction = false;
    boolean showUnmountAction = false;

    public MountPoint(JCRMountPointNode node) throws RepositoryException {
        this.realName = node.getName();
        this.name = StringUtils.removeEnd((String)node.getName(), (String)"-mount");
        this.path = node.getTargetMountPointPath();
        try {
            node.getSession().getNode(this.path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.status = node.getMountStatus();
        this.identifier = node.getIdentifier();
        this.nodetype = node.getPrimaryNodeType().getName();
        switch (node.getMountStatus()) {
            case unmounted: {
                this.displayStatusClass = "";
                this.showMountAction = true;
                break;
            }
            case mounted: {
                this.showUnmountAction = true;
                this.displayStatusClass = "label-success";
                break;
            }
            case error: {
                this.displayStatusClass = "label-important";
                break;
            }
            case waiting: {
                this.displayStatusClass = "label-warning";
            }
        }
        try {
            Locale locale = LocaleContextHolder.getLocale();
            this.mountPointProperties = new LinkedHashMap<String, String>();
            JCRValueWrapper[] protectedProperties = node.hasProperty("protectedProperties") ? node.getProperty("protectedProperties").getValues() : null;
            ArrayList<String> protectedPropertiesNames = null;
            if (protectedProperties != null) {
                protectedPropertiesNames = new ArrayList<String>();
                for (JCRValueWrapper jCRValueWrapper : protectedProperties) {
                    protectedPropertiesNames.add(jCRValueWrapper.getString());
                }
            }
            for (JCRValueWrapper jCRValueWrapper : NodeTypeRegistry.getInstance().getNodeType(this.nodetype).getDeclaredPropertyDefinitions()) {
                JCRPropertyWrapper mountPointProperty;
                ExtendedPropertyDefinition extPropDef;
                if (!node.hasProperty(jCRValueWrapper.getName()) || protectedPropertiesNames != null && protectedPropertiesNames.contains(jCRValueWrapper.getName()) || (extPropDef = (ExtendedPropertyDefinition)(mountPointProperty = node.getProperty(jCRValueWrapper.getName())).getDefinition()).isHidden()) continue;
                String key = extPropDef.getLabel(locale) + " (" + jCRValueWrapper.getName() + ")";
                if (mountPointProperty.isMultiple()) {
                    StringBuilder sb = new StringBuilder();
                    for (JCRValueWrapper v : mountPointProperty.getValues()) {
                        if (sb.length() > 0) {
                            sb.append(" - ");
                        }
                        sb.append(v.getString());
                    }
                    this.mountPointProperties.put(key, sb.toString());
                    continue;
                }
                this.mountPointProperties.put(key, mountPointProperty.getValue().getString());
            }
        }
        catch (NoSuchNodeTypeException e) {
            logger.warn("unable to get declared properties for " + this.nodetype);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public JCRMountPointNode.MountStatus getStatus() {
        return this.status;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setStatus(JCRMountPointNode.MountStatus status) {
        this.status = status;
    }

    public String getDisplayStatusClass() {
        return this.displayStatusClass;
    }

    public void setDisplayStatusClass(String displayStatusClass) {
        this.displayStatusClass = displayStatusClass;
    }

    public boolean isShowMountAction() {
        return this.showMountAction;
    }

    public void setShowMountAction(boolean showMountAction) {
        this.showMountAction = showMountAction;
    }

    public boolean isShowUnmountAction() {
        return this.showUnmountAction;
    }

    public void setShowUnmountAction(boolean showUnmountAction) {
        this.showUnmountAction = showUnmountAction;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getNodetype() {
        return this.nodetype;
    }

    public void setNodetype(String nodetype) {
        this.nodetype = nodetype;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public Map<String, String> getRemoteProperties() {
        return this.mountPointProperties;
    }
}

