/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.admin.mount.validator;

import javax.jcr.RepositoryException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.external.admin.mount.validator.LocalJCRFolder;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalJCRFolderValidator
implements ConstraintValidator<LocalJCRFolder, String> {
    private static final Logger logger = LoggerFactory.getLogger(LocalJCRFolderValidator.class);

    public void initialize(LocalJCRFolder localJCRFolder) {
    }

    public boolean isValid(final String s, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty((String)s)) {
            return true;
        }
        try {
            return (Boolean)JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper localNode = session.getNode(s);
                    return localNode.isNodeType("jnt:folder");
                }
            });
        }
        catch (RepositoryException e) {
            logger.debug("Error validating local path: " + s, (Throwable)e);
            return false;
        }
    }
}

