/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.events.rest;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventApiConfig
implements ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(EventApiConfig.class);
    private Map<String, ApiKeyCapabilities> apiKeys = new HashMap<String, ApiKeyCapabilities>();

    public void updated(Dictionary<String, ?> properties) {
        this.apiKeys.clear();
        if (properties != null) {
            Enumeration<String> keys = properties.keys();
            while (keys.hasMoreElements()) {
                HashSet<String> apiKeyProviders;
                String key = keys.nextElement();
                if (!StringUtils.endsWith((String)key, (String)"event.api.key")) continue;
                String apiKey = (String)properties.get(key);
                String apiKeyProvidersValue = (String)properties.get(StringUtils.substringBeforeLast((String)key, (String)".key") + ".providers");
                Set<String> set = apiKeyProviders = StringUtils.isNotEmpty((String)apiKeyProvidersValue) ? Stream.of(apiKeyProvidersValue.split(",")).collect(Collectors.toSet()) : new HashSet<String>();
                if (this.apiKeys.containsKey(apiKey)) {
                    this.apiKeys.get(apiKey).getProviders().addAll(apiKeyProviders);
                    continue;
                }
                this.apiKeys.put(apiKey, new ApiKeyCapabilities(apiKeyProviders));
            }
        }
        logger.info("External Provider Events API configuration reloaded");
    }

    boolean checkApiKey(String apiKey, String providerKey) {
        ApiKeyCapabilities apiKeyCapabilities = this.apiKeys.get(apiKey);
        if (apiKeyCapabilities != null) {
            return apiKeyCapabilities.getProviders().isEmpty() || apiKeyCapabilities.getProviders().contains(providerKey);
        }
        return false;
    }

    private class ApiKeyCapabilities {
        Set<String> providers;

        ApiKeyCapabilities(Set<String> providers) {
            this.providers = providers;
        }

        public Set<String> getProviders() {
            return this.providers;
        }

        public void setProviders(Set<String> providers) {
            this.providers = providers;
        }
    }
}

