/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.events.validation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.external.ExternalData;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ExternalDataValidator.class})
@Documented
public @interface ValidExternalData {
    public String message() default "Missing mandatory properties on external data object, mandatory properties: id, path, type";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class ExternalDataValidator
    implements ConstraintValidator<ValidExternalData, Map> {
        public void initialize(ValidExternalData validExternalData) {
        }

        public boolean isValid(Map info, ConstraintValidatorContext constraintValidatorContext) {
            ExternalData externalData = (ExternalData)info.get("externalData");
            if (externalData != null) {
                return StringUtils.isNotEmpty((String)externalData.getId()) && StringUtils.isNotEmpty((String)externalData.getPath()) && StringUtils.isNotEmpty((String)externalData.getType());
            }
            return true;
        }
    }
}

