/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.events.validation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.jackrabbit.util.ISO8601;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={Validator.class})
@Documented
public @interface ValidISO8601 {
    public String message() default "invalid date format, must be ISO8601 ( YYYY-MM-ddTHH:mm:ss.SSSZ )";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class Validator
    implements ConstraintValidator<ValidISO8601, String> {
        public void initialize(ValidISO8601 validExternalData) {
        }

        public boolean isValid(String date, ConstraintValidatorContext constraintValidatorContext) {
            return date == null || ISO8601.parse((String)date) != null;
        }
    }
}

