/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.query.sql2.Parser;
import org.apache.jackrabbit.core.query.JahiaSimpleQueryResult;
import org.apache.jackrabbit.core.query.lucene.CountRow;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelFactoryImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.modules.external.ExternalDataSource;
import org.jahia.modules.external.ExternalQuery;
import org.jahia.modules.external.ExternalSessionImpl;
import org.jahia.modules.external.ExternalWorkspaceImpl;
import org.jahia.modules.external.query.ExternalCountRowResult;
import org.jahia.modules.external.query.ExternalQueryResult;
import org.jahia.modules.external.query.QueryHelper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalQueryManager
implements QueryManager {
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"JCR-SQL2"};
    private static final String FACET_MARKER = "rep:facet(";
    private static final String COUNT_MARKER = "rep:count(";
    private static final String EXTENSION_MIXIN = "jmix:externalProviderExtension";
    private static final String EXTENDED_TYPE_PROPERTY = "j:extendedType";
    private static final String EXTENSION_TYPE = "jnt:externalProviderExtension";
    private static Logger logger = LoggerFactory.getLogger(ExternalQueryManager.class);
    private ExternalWorkspaceImpl workspace;

    public ExternalQueryManager(ExternalWorkspaceImpl workspace) {
        this.workspace = workspace;
    }

    public Query createQuery(String statement, String language) throws InvalidQueryException, RepositoryException {
        if (!language.equals("JCR-SQL2")) {
            throw new InvalidQueryException("Unsupported query language");
        }
        Parser p = new Parser(this.getQOMFactory(), (ValueFactory)this.workspace.getSession().getValueFactory());
        return p.createQueryObjectModel(statement);
    }

    public QueryObjectModelFactory getQOMFactory() {
        return new ExternalQOMFactory((NamePathResolver)this.workspace.getSession().getRepository().getNamePathResolver());
    }

    public Query getQuery(Node node) throws InvalidQueryException, RepositoryException {
        return null;
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        return Arrays.copyOf(SUPPORTED_LANGUAGES, SUPPORTED_LANGUAGES.length);
    }

    class ExecutableExternalQuery
    extends ExternalQuery {
        private boolean nodeTypeSupported;
        private boolean hasExtension;

        ExecutableExternalQuery(Source source, Constraint constraints, Ordering[] orderings, Column[] columns, boolean nodeTypeSupported, boolean hasExtension) {
            super(source, constraints, orderings, columns);
            this.nodeTypeSupported = nodeTypeSupported;
            this.hasExtension = hasExtension;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public QueryResult execute() throws InvalidQueryException, RepositoryException {
            long count;
            boolean isCount;
            ExternalDataSource dataSource;
            List<String> results;
            block35: {
                results = new ArrayList<String>();
                ExternalSessionImpl session = ExternalQueryManager.this.workspace.getSession();
                dataSource = session.getRepository().getDataSource();
                boolean noConstraints = this.isNoConstraints();
                Source source = this.getSource();
                boolean isMixinOrFacet = false;
                isCount = false;
                count = 0L;
                long originalLimit = this.getLimit();
                String selectorType = null;
                String selectorName = null;
                if (source instanceof Selector) {
                    selectorType = ((Selector)source).getNodeTypeName();
                    selectorName = ((Selector)source).getSelectorName();
                    isMixinOrFacet = NodeTypeRegistry.getInstance().getNodeType(selectorType).isMixin();
                    for (Column c : this.getColumns()) {
                        String columnName = c.getColumnName();
                        if (StringUtils.startsWith((String)columnName, (String)ExternalQueryManager.FACET_MARKER)) {
                            isMixinOrFacet = true;
                            break;
                        }
                        if (!StringUtils.startsWith((String)columnName, (String)ExternalQueryManager.COUNT_MARKER)) continue;
                        isCount = true;
                        break;
                    }
                }
                long lastItemIndex = this.getOffset() + this.getLimit();
                if (this.hasExtension) {
                    boolean hasLimit;
                    Session extSession = session.getExtensionSession();
                    QueryManager queryManager = extSession.getWorkspace().getQueryManager();
                    QueryObjectModelFactory qomFactory = queryManager.getQOMFactory();
                    if (source instanceof Selector) {
                        String selector = isMixinOrFacet || isCount ? selectorType : ExternalQueryManager.EXTENSION_MIXIN;
                        source = qomFactory.selector(selector, selectorName);
                    }
                    ExternalContentStoreProvider storeProvider = session.getRepository().getStoreProvider();
                    String mountPoint = storeProvider.getMountPoint();
                    Constraint convertedConstraint = this.convertExistingPathConstraints(this.getConstraint(), mountPoint, qomFactory);
                    if (!this.hasDescendantNode(convertedConstraint)) {
                        convertedConstraint = this.addPathConstraints(convertedConstraint, source, mountPoint, qomFactory);
                    }
                    if (!isCount && !isMixinOrFacet && selectorName != null && selectorType != null) {
                        Comparison c = qomFactory.comparison((DynamicOperand)qomFactory.propertyValue(selectorName, ExternalQueryManager.EXTENDED_TYPE_PROPERTY), "jcr.operator.equal.to", (StaticOperand)qomFactory.literal(extSession.getValueFactory().createValue(selectorType)));
                        convertedConstraint = qomFactory.and((Constraint)c, convertedConstraint);
                    }
                    QueryObjectModel q = qomFactory.createQuery(source, convertedConstraint, this.getOrderings(), this.getColumns());
                    boolean bl = hasLimit = this.getLimit() > -1L;
                    if (!this.nodeTypeSupported) {
                        if (hasLimit) {
                            q.setLimit(this.getLimit());
                        }
                        q.setOffset(this.getOffset());
                        QueryResult result = q.execute();
                        if (!isCount) {
                            NodeIterator nodes = new QueryResultAdapter(result).getNodes();
                            while (nodes.hasNext()) {
                                Node node = (Node)nodes.next();
                                if (node == null) {
                                    String warnMsg = String.format("A null node is returned for the statement %s, the Lucene indexes might be corrupted", q.getStatement());
                                    logger.warn(warnMsg);
                                    continue;
                                }
                                results.add(node.getPath().substring(mountPoint.length()));
                            }
                        } else {
                            count = this.getCount(result);
                        }
                        return this.buildQueryResult(results, dataSource, isCount, count);
                    }
                    QueryResult queryResult = q.execute();
                    if (!isCount) {
                        NodeIterator nodes = new QueryResultAdapter(queryResult).getNodes();
                        while (nodes.hasNext()) {
                            boolean matchExtensionConstraint;
                            Node node = (Node)nodes.next();
                            if (node == null) {
                                String warnMsg = String.format("A null node is returned for the statement %s, the Lucene indexes might be corrupted", q.getStatement());
                                logger.warn(warnMsg);
                                continue;
                            }
                            String path = node.getPath().substring(mountPoint.length());
                            boolean isNotExtension = !node.isNodeType(ExternalQueryManager.EXTENSION_TYPE);
                            boolean bl2 = matchExtensionConstraint = !noConstraints && session.itemExists(path);
                            if (!isNotExtension && !matchExtensionConstraint) continue;
                            results.add(path);
                            if (!hasLimit || (long)results.size() <= lastItemIndex) continue;
                            break;
                        }
                    } else {
                        count = this.getCount(queryResult);
                    }
                    if (results.isEmpty()) {
                        results = null;
                    } else {
                        boolean offsetNotReached;
                        boolean bl3 = offsetNotReached = this.getOffset() >= (long)results.size();
                        if (offsetNotReached) {
                            this.setOffset(this.getOffset() - (long)results.size());
                            results.clear();
                        } else if (hasLimit) {
                            int resultsSize = results.size();
                            results = results.subList((int)this.getOffset(), Math.min((int)this.getOffset() + (int)this.getLimit(), resultsSize));
                            this.setOffset(0L);
                            this.setLimit(this.getLimit() - (long)results.size());
                        } else {
                            boolean hasOffset;
                            boolean bl4 = hasOffset = this.getOffset() > 0L;
                            if (hasOffset) {
                                results = results.subList((int)this.getOffset(), results.size());
                                this.setOffset(0L);
                            }
                        }
                    }
                    if (this.getLimit() == 0L) {
                        return this.buildQueryResult(results, dataSource, isCount, count);
                    }
                }
                ExternalContentStoreProvider.setCurrentSession(session);
                try {
                    if (isCount && dataSource instanceof ExternalDataSource.SupportCount) {
                        count += ((ExternalDataSource.SupportCount)((Object)dataSource)).count(this);
                        break block35;
                    }
                    if (isCount) break block35;
                    if (results == null) {
                        results = ((ExternalDataSource.Searchable)((Object)dataSource)).search(this);
                        break block35;
                    }
                    if (noConstraints) {
                        results.addAll(((ExternalDataSource.Searchable)((Object)dataSource)).search(this));
                        break block35;
                    }
                    List<String> providerResult = ((ExternalDataSource.Searchable)((Object)dataSource)).search(this);
                    for (String s : providerResult) {
                        if (results.contains(s)) continue;
                        results.add(s);
                        if (originalLimit <= -1L || (long)results.size() < originalLimit) continue;
                        break;
                    }
                }
                catch (UnsupportedRepositoryOperationException e) {
                    logger.debug("Unsupported query ", (Throwable)e);
                }
                finally {
                    ExternalContentStoreProvider.removeCurrentSession();
                }
            }
            return this.buildQueryResult(results, dataSource, isCount, count);
        }

        private boolean isNoConstraints() throws RepositoryException {
            boolean noConstraints = false;
            try {
                if (QueryHelper.getSimpleAndConstraints(this.getConstraint()).size() == 0) {
                    noConstraints = true;
                }
            }
            catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
                // empty catch block
            }
            return noConstraints;
        }

        private QueryResult buildQueryResult(List<String> results, ExternalDataSource dataSource, boolean isCount, long count) throws RepositoryException {
            if (isCount) {
                ExternalCountRowResult rowCountResult = new ExternalCountRowResult((QueryObjectModel)this, count, ExternalQueryManager.this.workspace);
                return new JahiaSimpleQueryResult(rowCountResult.getColumnNames(), rowCountResult.getSelectorNames(), rowCountResult.getRows());
            }
            if (results == null) {
                results = Collections.emptyList();
            }
            return new ExternalQueryResult(this, results, ExternalQueryManager.this.workspace);
        }

        private long getCount(QueryResult result) throws RepositoryException {
            Row row;
            Row row2 = row = result.getRows().hasNext() ? result.getRows().nextRow() : null;
            if (row instanceof CountRow) {
                return row.getValue("").getLong();
            }
            return 0L;
        }

        private boolean hasDescendantNode(Constraint convertedConstraint) {
            if (convertedConstraint instanceof DescendantNode) {
                return true;
            }
            if (convertedConstraint instanceof And) {
                return this.hasDescendantNode(((And)convertedConstraint).getConstraint1()) || this.hasDescendantNode(((And)convertedConstraint).getConstraint2());
            }
            return false;
        }

        private Constraint addPathConstraints(Constraint constraint, Source source, String mountPoint, QueryObjectModelFactory f) throws RepositoryException {
            Object result = constraint;
            if (source instanceof Selector) {
                DescendantNode descendantNode = f.descendantNode(((Selector)source).getSelectorName(), mountPoint);
                result = result == null ? descendantNode : f.and(result, (Constraint)descendantNode);
            } else if (source instanceof Join) {
                result = this.addPathConstraints((Constraint)result, ((Join)source).getLeft(), mountPoint, f);
                result = this.addPathConstraints((Constraint)result, ((Join)source).getRight(), mountPoint, f);
            }
            return result;
        }

        private Constraint convertExistingPathConstraints(Constraint constraint, String mountPoint, QueryObjectModelFactory f) throws RepositoryException {
            if (constraint instanceof ChildNode) {
                String root = ((ChildNode)constraint).getParentPath();
                return f.childNode(((ChildNode)constraint).getSelectorName(), mountPoint + root);
            }
            if (constraint instanceof DescendantNode) {
                String root = ((DescendantNode)constraint).getAncestorPath();
                return f.descendantNode(((DescendantNode)constraint).getSelectorName(), mountPoint + root);
            }
            if (constraint instanceof And) {
                Constraint c1 = this.convertExistingPathConstraints(((And)constraint).getConstraint1(), mountPoint, f);
                Constraint c2 = this.convertExistingPathConstraints(((And)constraint).getConstraint2(), mountPoint, f);
                return f.and(c1, c2);
            }
            if (constraint instanceof Or) {
                Constraint c1 = this.convertExistingPathConstraints(((Or)constraint).getConstraint1(), mountPoint, f);
                Constraint c2 = this.convertExistingPathConstraints(((Or)constraint).getConstraint2(), mountPoint, f);
                return f.or(c1, c2);
            }
            if (constraint instanceof Not) {
                return f.not(this.convertExistingPathConstraints(((Not)constraint).getConstraint(), mountPoint, f));
            }
            return constraint;
        }

        private class QueryResultAdapter
        implements QueryResult {
            private final QueryResult result;

            public QueryResultAdapter(QueryResult result) {
                this.result = result;
            }

            public String[] getColumnNames() throws RepositoryException {
                return this.result.getColumnNames();
            }

            public RowIterator getRows() throws RepositoryException {
                return this.result.getRows();
            }

            public NodeIterator getNodes() throws RepositoryException {
                if (this.result.getSelectorNames().length <= 1) {
                    return this.result.getNodes();
                }
                return new NodeIteratorAdapter((RangeIterator)this.result.getRows()){

                    public Object next() {
                        Row row = (Row)super.next();
                        try {
                            return row.getNode(QueryResultAdapter.this.result.getSelectorNames()[0]);
                        }
                        catch (RepositoryException e) {
                            throw new UnsupportedOperationException("Unable to access the node in " + row, e);
                        }
                    }
                };
            }

            public String[] getSelectorNames() throws RepositoryException {
                return this.result.getSelectorNames();
            }
        }
    }

    class ExternalQOMFactory
    extends QueryObjectModelFactoryImpl
    implements QueryObjectModelFactory {
        ExternalQOMFactory(NamePathResolver resolver) {
            super(resolver);
        }

        protected QueryObjectModel createQuery(QueryObjectModelTree qomTree) throws InvalidQueryException, RepositoryException {
            boolean hasExtension;
            boolean nodeTypeSupported = this.isNodeTypeSupported(qomTree);
            boolean bl = hasExtension = ExternalQueryManager.this.workspace.getSession().getExtensionSession() != null;
            if (!nodeTypeSupported && !hasExtension) {
                return null;
            }
            return new ExecutableExternalQuery((Source)qomTree.getSource(), (Constraint)qomTree.getConstraint(), (Ordering[])qomTree.getOrderings(), (Column[])qomTree.getColumns(), nodeTypeSupported, hasExtension);
        }

        private boolean isNodeTypeSupported(QueryObjectModelTree qomTree) throws NoSuchNodeTypeException {
            if (!(qomTree.getSource() instanceof Selector)) {
                return false;
            }
            NodeTypeRegistry ntRegistry = NodeTypeRegistry.getInstance();
            ExtendedNodeType type = null;
            try {
                type = ntRegistry.getNodeType(((Selector)qomTree.getSource()).getNodeTypeName());
            }
            catch (NoSuchNodeTypeException e) {
                return false;
            }
            String nodeType = type.getName();
            Set<String> supportedNodeTypes = ExternalQueryManager.this.workspace.getSession().getRepository().getDataSource().getSupportedNodeTypes();
            if (supportedNodeTypes.contains(nodeType)) {
                return true;
            }
            for (String supportedNodeType : supportedNodeTypes) {
                try {
                    if (!ntRegistry.getNodeType(supportedNodeType).isNodeType(nodeType)) continue;
                    return true;
                }
                catch (NoSuchNodeTypeException e) {
                    logger.error("no such node type", (Throwable)e);
                }
            }
            return false;
        }
    }
}

