/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.query;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Selector;
import org.apache.commons.lang.ArrayUtils;
import org.jahia.modules.external.ExternalWorkspaceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalQueryResult
implements QueryResult {
    private static final Logger logger = LoggerFactory.getLogger(ExternalQueryResult.class);
    private String[] columns;
    private QueryObjectModel qom;
    private List<String> results;
    private String[] selectors;
    private ExternalWorkspaceImpl workspace;

    ExternalQueryResult(QueryObjectModel qom, List<String> results, ExternalWorkspaceImpl workspace) {
        this.qom = qom;
        this.results = results;
        this.workspace = workspace;
    }

    public String[] getColumnNames() throws RepositoryException {
        if (this.columns == null) {
            if (this.qom.getColumns().length == 0) {
                this.columns = ArrayUtils.EMPTY_STRING_ARRAY;
            } else {
                LinkedList<String> columnList = new LinkedList<String>();
                for (Column c : this.qom.getColumns()) {
                    if (c.getColumnName() == null) continue;
                    columnList.add(c.getColumnName());
                }
                this.columns = columnList.toArray(new String[0]);
            }
        }
        return this.columns;
    }

    public NodeIterator getNodes() throws RepositoryException {
        Iterator<String> it = this.results.iterator();
        return new ExternalQueryNodeIterator(it);
    }

    public RowIterator getRows() throws RepositoryException {
        Iterator<String> it = this.results.iterator();
        return new ExternalQueryRowIterator(it);
    }

    public String[] getSelectorNames() throws RepositoryException {
        if (this.selectors == null) {
            this.selectors = this.qom.getSource() instanceof Selector ? new String[]{((Selector)this.qom.getSource()).getSelectorName()} : ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return this.selectors;
    }

    private class ExternalQueryRowIterator
    implements RowIterator {
        private final Iterator<String> it;
        private int pos;

        public ExternalQueryRowIterator(Iterator<String> it) {
            this.it = it;
            this.pos = 0;
        }

        public long getPosition() {
            return this.pos;
        }

        public long getSize() {
            return ExternalQueryResult.this.results.size();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return this.nextRow();
        }

        public Row nextRow() {
            try {
                Node n = ExternalQueryResult.this.workspace.getSession().getNode(this.it.next());
                return new ExternalQueryRow(n);
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void skip(long skipNum) {
            int i = 0;
            while ((long)i < skipNum) {
                this.it.next();
                ++i;
            }
            this.pos = (int)((long)this.pos + skipNum);
        }

        private class ExternalQueryRow
        implements Row {
            private final Node n;

            public ExternalQueryRow(Node n) {
                this.n = n;
            }

            public Value[] getValues() throws RepositoryException {
                return new Value[0];
            }

            public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
                return null;
            }

            public Node getNode() throws RepositoryException {
                return this.n;
            }

            public Node getNode(String selectorName) throws RepositoryException {
                return this.n;
            }

            public String getPath() throws RepositoryException {
                return this.n.getPath();
            }

            public String getPath(String selectorName) throws RepositoryException {
                return this.n.getPath();
            }

            public double getScore() throws RepositoryException {
                return 0.0;
            }

            public double getScore(String selectorName) throws RepositoryException {
                return 0.0;
            }
        }
    }

    private class ExternalQueryNodeIterator
    implements NodeIterator {
        private final Iterator<String> it;
        private int pos;

        public ExternalQueryNodeIterator(Iterator<String> it) {
            this.it = it;
            this.pos = 0;
        }

        public long getPosition() {
            return this.pos;
        }

        public long getSize() {
            return ExternalQueryResult.this.results.size();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return this.nextNode();
        }

        public Node nextNode() {
            try {
                return ExternalQueryResult.this.workspace.getSession().getNode(this.it.next());
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void skip(long skipNum) {
            int i = 0;
            while ((long)i < skipNum) {
                this.it.next();
                ++i;
            }
            this.pos = (int)((long)this.pos + skipNum);
        }
    }
}

