/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.macros.filter;

import java.io.IOException;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLGenerator;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.utils.FileUtils;
import org.jahia.utils.Patterns;
import org.jahia.utils.ScriptEngineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;

public class MacrosFilter
extends AbstractFilter
implements InitializingBean,
ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent> {
    private static transient Logger logger = LoggerFactory.getLogger(MacrosFilter.class);
    private String[] macroLookupPath;
    private Pattern macrosPattern;
    private Map<String, String[]> scriptCache;
    private ScriptEngineUtils scriptEngineUtils;
    private boolean replaceByErrorMessageOnMissingMacros = true;

    public void afterPropertiesSet() throws Exception {
        this.scriptCache = new LinkedHashMap<String, String[]>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        if (StringUtils.isEmpty((String)previousOut)) {
            return previousOut;
        }
        long timer = System.currentTimeMillis();
        boolean evaluated = false;
        Matcher matcher = this.macrosPattern.matcher(previousOut);
        while (matcher.find()) {
            evaluated = true;
            String macroName = matcher.group(1);
            if (StringUtils.isEmpty((String)macroName)) continue;
            String[] macro = this.getMacro(macroName, renderContext);
            if (macro != null) {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                JahiaTemplatesPackage module = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(macro[2]);
                Thread.currentThread().setContextClassLoader(module.getChainedClassLoader());
                try {
                    ScriptEngine scriptEngine = this.scriptEngineUtils.scriptEngine(macro[1]);
                    SimpleScriptContext scriptContext = new SimpleScriptContext();
                    scriptContext.setBindings(this.getBindings(renderContext, resource, scriptContext, matcher), 100);
                    scriptContext.setBindings(scriptEngine.getContext().getBindings(200), 200);
                    scriptContext.setWriter(new StringWriter());
                    scriptContext.setErrorWriter(new StringWriter());
                    scriptEngine.eval(macro[0], (ScriptContext)scriptContext);
                    String scriptResult = scriptContext.getWriter().toString().trim();
                    previousOut = StringUtils.replace((String)previousOut, (String)matcher.group(), (String)scriptResult);
                }
                catch (ScriptException e) {
                    logger.warn("Error during execution of macro " + macroName + " with message " + e.getMessage(), (Throwable)e);
                    previousOut = matcher.replaceFirst(macroName);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(tccl);
                }
                matcher = this.macrosPattern.matcher(previousOut);
                continue;
            }
            if (!this.replaceByErrorMessageOnMissingMacros) continue;
            previousOut = matcher.replaceFirst("macro " + macroName + " not found");
            logger.warn("Unknown macro '{}'", (Object)macroName);
            matcher = this.macrosPattern.matcher(previousOut);
        }
        if (evaluated && logger.isDebugEnabled()) {
            logger.debug("Evaluation of macros took {} ms", (Object)(System.currentTimeMillis() - timer));
        }
        return previousOut;
    }

    private Bindings getBindings(RenderContext renderContext, Resource resource, ScriptContext scriptContext, Matcher matcher) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("currentUser", (Object)renderContext.getUser());
        bindings.put("currentNode", (Object)resource.getNode());
        bindings.put("currentResource", (Object)resource);
        bindings.put("renderContext", (Object)renderContext);
        URLGenerator generator = renderContext.getURLGenerator();
        if (!generator.uses(resource)) {
            generator = new URLGenerator(renderContext, resource);
        }
        bindings.put("url", (Object)generator);
        String group = matcher.group(3);
        if (group != null) {
            int i = 1;
            for (String s : Patterns.COMMA.split(group)) {
                bindings.put("param" + i++, (Object)s);
            }
        }
        try {
            bindings.put("currentAliasUser", (Object)renderContext.getMainResource().getNode().getSession().getAliasedUser());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return bindings;
    }

    protected String[] getMacro(String macroName, RenderContext renderContext) {
        String[] macro = this.scriptCache.get(macroName);
        if (macro != null || !this.replaceByErrorMessageOnMissingMacros && this.scriptCache.containsKey(macroName)) {
            return macro;
        }
        List m = renderContext.getSite().getInstalledModules();
        LinkedHashSet<JahiaTemplatesPackage> packages = new LinkedHashSet<JahiaTemplatesPackage>();
        packages.add(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById("macros"));
        for (String s : m) {
            JahiaTemplatesPackage pack = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(s);
            if (pack == null) continue;
            packages.add(pack);
            packages.addAll(pack.getDependencies());
        }
        try {
            for (JahiaTemplatesPackage aPackage : packages) {
                for (String path : this.macroLookupPath) {
                    org.springframework.core.io.Resource[] resources;
                    for (org.springframework.core.io.Resource resource : resources = aPackage.getResources(path)) {
                        if (!resource.getFilename().startsWith(macroName)) continue;
                        macro = new String[]{FileUtils.getContent((org.springframework.core.io.Resource)resource), FilenameUtils.getExtension((String)resource.getFilename()), aPackage.getId()};
                        this.scriptCache.put(macroName, macro);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Script of type {}, content:\n{}", (Object)macro[1], (Object)macro[0]);
                        }
                        return macro;
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("Cannot read files", (Throwable)e);
        }
        if (!this.replaceByErrorMessageOnMissingMacros) {
            this.scriptCache.put(macroName, null);
        }
        return null;
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent event) {
        this.scriptCache.clear();
    }

    public void setMacroLookupPath(String macroLookupPath) {
        this.macroLookupPath = macroLookupPath.split(",");
    }

    public void setMacrosRegexp(String macrosRegexp) {
        this.macrosPattern = Pattern.compile(macrosRegexp);
    }

    public void setScriptEngineUtils(ScriptEngineUtils scriptEngineUtils) {
        this.scriptEngineUtils = scriptEngineUtils;
    }

    public void setReplaceByErrorMessageOnMissingMacros(boolean replaceByErrorMessageOnMissingMacros) {
        this.replaceByErrorMessageOnMissingMacros = replaceByErrorMessageOnMissingMacros;
    }
}

