/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.macros.initializers;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.content.nodetypes.initializers.ModuleChoiceListInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class MacrosChoiceListInitializer
implements ModuleChoiceListInitializer {
    private static transient Logger logger = LoggerFactory.getLogger(MacrosChoiceListInitializer.class);
    private String key;
    private String[] macroLookupPath;
    private List ignoreMacros;

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        ArrayList<ChoiceListValue> macrosNames = new ArrayList<ChoiceListValue>();
        JCRNodeWrapper node = null;
        if (context.containsKey("contextNode") && context.get("contextNode") != null) {
            node = (JCRNodeWrapper)context.get("contextNode");
        } else if (context.containsKey("contextParent") && context.get("contextParent") != null) {
            node = (JCRNodeWrapper)context.get("contextParent");
        }
        if (node != null) {
            try {
                LinkedHashSet<JahiaTemplatesPackage> packages = new LinkedHashSet<JahiaTemplatesPackage>();
                packages.add(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById("macros"));
                for (String s : node.getResolveSite().getInstalledModules()) {
                    JahiaTemplatesPackage pack = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(s);
                    if (pack == null) continue;
                    packages.add(pack);
                    List dependencies = pack.getDependencies();
                    if (dependencies == null || dependencies.isEmpty()) continue;
                    packages.addAll(dependencies);
                }
                for (JahiaTemplatesPackage aPackage : packages) {
                    for (String path : this.macroLookupPath) {
                        Resource[] resources;
                        for (Resource resource : resources = aPackage.getResources(path)) {
                            String macroName = StringUtils.substringBefore((String)resource.getFilename(), (String)".");
                            if (this.ignoreMacros == null || this.ignoreMacros.contains(macroName)) continue;
                            macroName = "##" + macroName + "##";
                            macrosNames.add(new ChoiceListValue(macroName, macroName));
                        }
                    }
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot resolve site", (Throwable)e);
            }
        }
        return macrosNames;
    }

    public void setMacroLookupPath(String macroLookupPath) {
        this.macroLookupPath = macroLookupPath.split(",");
    }

    public void setIgnoreMacros(List ignoreMacros) {
        this.ignoreMacros = ignoreMacros;
    }
}

