/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.rating.actions;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.bin.Render;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateContent
extends Action {
    JCRTemplate jcrTemplate;
    private static Logger logger = LoggerFactory.getLogger(RateContent.class);

    public void setJcrTemplate(JCRTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, final Resource resource, JCRSessionWrapper session, final Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        return (ActionResult)this.jcrTemplate.doExecuteWithSystemSession(null, session.getWorkspace().getName(), session.getLocale(), (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper node = session.getNodeByUUID(resource.getNode().getIdentifier());
                if (!node.isNodeType("jmix:rating")) {
                    session.checkout((Node)node);
                    node.addMixin("jmix:rating");
                    session.save();
                }
                List values = (List)parameters.get("j:lastVote");
                node.setProperty("j:lastVote", (String)values.get(0));
                node.setProperty("j:nbOfVotes", node.getProperty("j:nbOfVotes").getLong() + 1L);
                node.setProperty("j:sumOfVotes", node.getProperty("j:sumOfVotes").getLong() + Long.valueOf((String)values.get(0)));
                node.setProperty("j:topRatedRatio", node.getProperty("j:sumOfVotes").getDouble() / node.getProperty("j:nbOfVotes").getDouble());
                session.save();
                try {
                    return new ActionResult(200, node.getPath(), Render.serializeNodeToJSON((JCRNodeWrapper)node));
                }
                catch (IOException e) {
                    logger.error("Error while creating rating action result", (Throwable)e);
                }
                catch (JSONException e) {
                    logger.error("Error while creating rating action result", (Throwable)e);
                }
                return null;
            }
        });
    }
}

