/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.tasks.rules;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.drools.core.spi.KnowledgeHelper;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.rules.AddedNodeFact;
import org.jahia.services.tasks.Task;
import org.jahia.services.tasks.TaskService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tasks {
    private static transient Logger logger = LoggerFactory.getLogger(Tasks.class);
    private static Tasks instance;
    private TaskService taskService;

    private Tasks() {
    }

    public static synchronized Tasks getInstance() {
        if (instance == null) {
            instance = new Tasks();
        }
        return instance;
    }

    public void createTask(String user, String title, String description, String priority, Date dueDate, String state, KnowledgeHelper drools) throws RepositoryException {
        Task task = new Task(title, description);
        if (priority != null) {
            task.setPriority(Task.Priority.valueOf((String)priority));
        }
        task.setDueDate(dueDate);
        if (state != null) {
            task.setState(Task.State.valueOf((String)state));
        }
        this.taskService.createTask(task, user);
    }

    public void createTask(AddedNodeFact user, String title, String description, String priority, Date dueDate, String state, KnowledgeHelper drools) throws RepositoryException {
        Task task = new Task(title, description);
        if (priority != null) {
            task.setPriority(Task.Priority.valueOf((String)priority));
        }
        task.setDueDate(dueDate);
        if (state != null) {
            task.setState(Task.State.valueOf((String)state));
        }
        this.taskService.createTask(task, (JCRUserNode)user.getNode());
    }

    public void createTask(String user, String title, String description, KnowledgeHelper drools) throws RepositoryException {
        this.createTask(user, title, description, null, null, null, drools);
    }

    public void createTask(AddedNodeFact user, String title, String description, KnowledgeHelper drools) throws RepositoryException {
        this.createTask(user, title, description, null, null, null, drools);
    }

    public void createTaskForGroupMembers(String group, String title, String description, KnowledgeHelper drools) throws RepositoryException {
        String siteKey = null;
        if (group.startsWith("/sites/")) {
            siteKey = StringUtils.substringBetween((String)group, (String)"/sites/", (String)"/");
        }
        if (group.indexOf(47) != -1) {
            group = StringUtils.substringAfterLast((String)group, (String)"/");
        }
        this.taskService.createTaskForGroup(new Task(title, description), group, siteKey);
    }

    public void createTaskForGroupMembers(AddedNodeFact group, String title, String description, KnowledgeHelper drools) throws RepositoryException {
        this.taskService.createTaskForGroup(new Task(title, description), (JCRGroupNode)group.getNode());
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void assignTask(AddedNodeFact node, String username) {
        JCRUserNode user = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUserByPath(username);
        try {
            JCRNodeWrapper jcrNodeWrapper = node.getNode();
            String taskId = jcrNodeWrapper.getProperty("taskId").getString();
            String provider = jcrNodeWrapper.getProperty("provider").getString();
            WorkflowService.getInstance().assignTask(taskId, provider, user != null ? user.getJahiaUser() : null);
        }
        catch (RepositoryException e) {
            logger.error("cannot assign task", (Throwable)e);
        }
    }

    public void completeTask(AddedNodeFact node, JahiaUser user) {
        try {
            JCRNodeWrapper jcrNodeWrapper = node.getNode();
            String taskId = jcrNodeWrapper.getProperty("taskId").getString();
            String provider = jcrNodeWrapper.getProperty("provider").getString();
            String outcome = jcrNodeWrapper.getProperty("finalOutcome").getString();
            HashMap map = null;
            if (jcrNodeWrapper.hasNode("taskData")) {
                map = new HashMap();
                JCRNodeWrapper data = jcrNodeWrapper.getNode("taskData");
                PropertyIterator pi = data.getProperties();
                while (pi.hasNext()) {
                    JCRPropertyWrapper property = (JCRPropertyWrapper)pi.next();
                    if (property.getDefinition().getDeclaringNodeType().getName().equals("nt:base") || property.getDefinition().getName().equals("jcr:uuid")) continue;
                    if (property.isMultiple()) {
                        ArrayList<WorkflowVariable> values = new ArrayList<WorkflowVariable>();
                        for (JCRValueWrapper value : property.getValues()) {
                            String s = value.getString();
                            if (!StringUtils.isNotBlank((String)s)) continue;
                            values.add(new WorkflowVariable(s, value.getType()));
                        }
                        map.put(property.getName(), values);
                        continue;
                    }
                    String s = property.getString();
                    if (!StringUtils.isNotBlank((String)s)) continue;
                    map.put(property.getName(), new WorkflowVariable(s, property.getType()));
                }
            }
            WorkflowService.getInstance().completeTask(taskId, user, provider, outcome, map);
        }
        catch (RepositoryException e) {
            logger.error("cannot complete task", (Throwable)e);
        }
    }
}

