/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.translation.initializers;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.log4j.Logger;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.content.nodetypes.initializers.ModuleChoiceListInitializer;
import org.jahia.utils.LanguageCodeConverters;

public class SiteLocaleChoiceListInitializer
implements ModuleChoiceListInitializer {
    private static transient Logger logger = Logger.getLogger(SiteLocaleChoiceListInitializer.class);
    private String key;

    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        JCRNodeWrapper node = (JCRNodeWrapper)context.get("contextNode");
        if (node == null) {
            node = (JCRNodeWrapper)context.get("contextParent");
        }
        if (node != null) {
            try {
                JCRSiteNode site = node.getResolveSite();
                Set activeLanguageCodes = site.getLanguages();
                ArrayList<ChoiceListValue> listValues = new ArrayList<ChoiceListValue>();
                for (String activeLanguageCode : activeLanguageCodes) {
                    if (site.getInactiveLanguages().contains(activeLanguageCode)) continue;
                    Locale localeFromCode = LanguageCodeConverters.getLocaleFromCode((String)activeLanguageCode);
                    listValues.add(new ChoiceListValue(localeFromCode.getDisplayName(locale), null, node.getSession().getValueFactory().createValue(activeLanguageCode)));
                }
                return listValues;
            }
            catch (RepositoryException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<ChoiceListValue>();
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }
}

