/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.data.definition;

import com.extjs.gxt.ui.client.data.BaseTreeModel;
import java.io.Serializable;
import java.util.Date;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;

public class GWTJahiaNodePropertyValue
extends BaseTreeModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String value;
    private int type;
    private GWTJahiaNode reference;
    private GWTJahiaNode linkNode;

    public GWTJahiaNodePropertyValue() {
    }

    public GWTJahiaNodePropertyValue(String value) {
        this(value, 1);
    }

    public GWTJahiaNodePropertyValue(String value, int type) {
        this();
        this.type = type;
        this.value = value;
    }

    public GWTJahiaNodePropertyValue(String value, GWTJahiaNode node, int type) {
        this();
        this.type = type;
        this.value = value;
        this.reference = node;
    }

    public GWTJahiaNodePropertyValue(GWTJahiaNode node, int type) {
        this.type = type;
        if (type == 9 || type == 10) {
            this.reference = node;
            this.value = this.reference.getUUID();
        } else if (type == 21) {
            this.linkNode = node;
            this.value = (String)node.get("jnt:url");
        } else {
            this.reference = node;
            this.value = node.getPath();
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            GWTJahiaNodePropertyValue val = (GWTJahiaNodePropertyValue)obj;
            return val.getType() == this.getType() && val.getString() != null && val.getString().equals(this.getString());
        }
        return false;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.type;
        return result;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getBinary() {
        return null;
    }

    public byte[] getStream() {
        return null;
    }

    public Boolean getBoolean() {
        if (this.type == 6 && this.value != null) {
            return Boolean.valueOf(this.value);
        }
        return null;
    }

    public Date getDate() {
        if (this.type == 5 && this.value != null) {
            return new Date(Long.valueOf(this.value));
        }
        return null;
    }

    public Float getDecimal() {
        if (this.type == 12 && this.value != null) {
            return Float.valueOf(this.value);
        }
        return null;
    }

    public Double getDouble() {
        if (this.type == 4 && this.value != null) {
            return Double.valueOf(this.value);
        }
        return null;
    }

    public Long getLong() {
        if (this.type == 3 && this.value != null) {
            return Double.valueOf(this.value).longValue();
        }
        return null;
    }

    public String getString() {
        return this.value;
    }

    public GWTJahiaNode getNode() {
        return this.reference;
    }

    public GWTJahiaNode getLinkNode() {
        return this.linkNode;
    }

    public String toString() {
        return this.getString();
    }
}

