/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;

public class URL {
    private static final String GWT_SCRIPT_PATH = "/gwt/";

    public static String getServerBaseURL() {
        String absoluteURLContext = GWT.getModuleBaseURL();
        String[] splittedUrl = absoluteURLContext.split("/");
        if (splittedUrl.length > 2) {
            return splittedUrl[0] + "//" + splittedUrl[2];
        }
        return null;
    }

    public static String getJahiaContext() {
        String contextPath = "";
        String baseUrl = GWT.getModuleBaseURL();
        String serverBaseUrl = URL.getServerBaseURL();
        int suffixPosition = (baseUrl = baseUrl.substring(serverBaseUrl.length())).indexOf(GWT_SCRIPT_PATH);
        if (suffixPosition != -1) {
            contextPath = baseUrl.substring(0, suffixPosition);
        }
        return contextPath;
    }

    public static String getAbsoluteURL(String url) {
        String server = URL.getServerBaseURL();
        return server + url;
    }

    public static String getRelativeURL() {
        return URL.getWindowUrl().replaceAll(URL.getJahiaContext(), "");
    }

    public static String getQueryString() {
        String windowUrl = URL.getWindowUrl();
        int separatorIndex = windowUrl.indexOf(63);
        if (separatorIndex > 0) {
            return windowUrl.substring(separatorIndex);
        }
        return null;
    }

    public static String getContextServletPath() {
        return JahiaGWTParameters.getContextPath() + JahiaGWTParameters.getServletPath();
    }

    public static String rewrite(String jahiaContextPath, String jahiaServletPath, String url) {
        if (url == null) {
            return null;
        }
        if (url.indexOf("/{mode}/{lang}/") > 0) {
            return url;
        }
        if (URL.isAbsoluteUrl(url)) {
            return url;
        }
        return jahiaContextPath + jahiaServletPath + "/{mode}/{lang}" + url;
    }

    private static boolean isAbsoluteUrl(String url) {
        String[] splittedUrl = url.split("/");
        return splittedUrl.length > 2 && splittedUrl[1].length() == 0;
    }

    public static native String getWindowUrl();

    public static String replacePlaceholders(String value, GWTJahiaNode selectedNode) {
        String home;
        if (value.contains("$context")) {
            value = value.replace("$context", JahiaGWTParameters.getContextPath());
        }
        if (value.contains("$siteuuid")) {
            value = value.replace("$siteuuid", JahiaGWTParameters.getSiteUUID());
        }
        if (value.contains("$base-url")) {
            value = value.replace("$base-url", JahiaGWTParameters.getBaseUrl());
        }
        if (value.contains("$site-path")) {
            value = value.replace("$site-path", JahiaGWTParameters.getSiteNode().getPath());
        }
        if (value.contains("$site-homepage-path") && (home = (String)JahiaGWTParameters.getSiteNode().get("homepage-path")) != null) {
            value = value.replace("$site-homepage-path", home);
        }
        if (value.contains("$lang")) {
            value = value.replace("$lang", JahiaGWTParameters.getLanguage());
        }
        if (value.contains("$nodepathnoescape") && selectedNode != null) {
            value = value.replace("$nodepathnoescape", selectedNode.getPath());
        }
        if (value.contains("$nodepath") && selectedNode != null) {
            value = value.replace("$nodepath", com.google.gwt.http.client.URL.encodeQueryString((String)selectedNode.getPath()));
        }
        if (value.contains("$workspace")) {
            value = value.replace("$workspace", JahiaGWTParameters.getWorkspace());
        }
        if (value.contains("$location-path")) {
            value = value.replace("$location-path", com.google.gwt.http.client.URL.encodeQueryString((String)Window.Location.getPath()));
        }
        if (value.contains("$location-hash")) {
            value = value.replace("$location-hash", com.google.gwt.http.client.URL.encodeQueryString((String)Window.Location.getHash()));
        }
        return value;
    }

    public static String appendTimestamp(String url) {
        if (url == null || url.length() == 0) {
            return url;
        }
        return url + (url.contains("?") ? "&refresh=" : "?refresh=") + System.currentTimeMillis();
    }
}

