/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTChoiceListInitializer;
import org.jahia.ajax.gwt.client.data.GWTJahiaEditEngineInitBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEngineTab;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.contentengine.ContentTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineValidation;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.tripanel.BottomRightComponent;

public class ContentDetails
extends BottomRightComponent
implements NodeHolder {
    private GWTManagerConfiguration config;
    private final ManagerLinker linker;
    private ContentPanel m_component;
    private TabPanel tabs;
    private List<GWTJahiaNodeType> types;
    private List<GWTJahiaNodeType> mixin;
    private Map<String, GWTChoiceListInitializer> initializersValues;
    protected Map<String, Map<String, List<GWTJahiaNodePropertyValue>>> defaultValues;
    private Map<String, GWTJahiaNodeProperty> properties = new HashMap<String, GWTJahiaNodeProperty>();
    private GWTJahiaLanguage language;
    private GWTJahiaNodeACL acl;
    private String defaultLanguageCode;
    protected Map<String, Set<String>> referencesWarnings;
    private List<GWTJahiaNode> selectedNodes = null;
    private boolean workInProgress = false;
    private final JahiaContentManagementServiceAsync service = JahiaContentManagementService.App.getInstance();
    private Button ok;
    private CheckBox wip;

    public ContentDetails(GWTManagerConfiguration config, ManagerLinker linker) {
        this.setComponentType("manager");
        this.config = config;
        this.linker = linker;
        this.m_component = new ContentPanel((Layout)new FitLayout());
        this.m_component.setBodyBorder(false);
        this.m_component.setBorders(true);
        this.m_component.setHeaderVisible(false);
        this.tabs = new TabPanel();
        this.tabs.setBodyBorder(false);
        this.tabs.setBorders(false);
        this.tabs.setAnimScroll(true);
        this.tabs.setTabScroll(true);
        this.initTabs();
        this.tabs.addListener(Events.Select, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent event) {
                if (ContentDetails.this.selectedNodes != null && ContentDetails.this.selectedNodes.size() > 0) {
                    ContentDetails.this.fillCurrentTab();
                }
            }
        });
        this.m_component.add((Widget)this.tabs);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setAlignment(Style.HorizontalAlignment.RIGHT);
        if (config.isShowWorkInProgress()) {
            this.wip = new CheckBox();
            this.wip.setValue(Boolean.valueOf(false));
            this.workInProgress = this.wip.getValue();
            this.wip.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent event) {
                    ContentDetails.this.workInProgress = ContentDetails.this.wip.getValue();
                }
            });
            this.wip.setBoxLabel(Messages.get("label.saveAsWIP", "Save as work in progress"));
            this.wip.setToolTip(Messages.get("label.saveAsWIP.information", "If checked, this content will ne be part of publication process"));
            buttonBar.add((Component)this.wip);
        }
        this.ok = new Button(Messages.get("label.save"));
        this.ok.addStyleName("button-save");
        this.ok.setEnabled(false);
        this.ok.setIcon(StandardIconsProvider.STANDARD_ICONS.engineButtonOK());
        this.ok.addSelectionListener((SelectionListener)new SaveSelectionListener());
        buttonBar.add((Component)this.ok);
        this.m_component.setBottomComponent((Component)buttonBar);
    }

    protected void initTabs() {
        for (GWTEngineTab tabConfig : this.config.getManagerEngineTabs()) {
            EditEngineTabItem tabItem = tabConfig.getTabItem();
            this.tabs.add((TabItem)tabItem.create(tabConfig, this));
        }
    }

    @Override
    public Component getComponent() {
        return this.m_component;
    }

    @Override
    public void clear() {
        this.m_component.setHeadingHtml("&nbsp;");
        this.selectedNodes = null;
        for (TabItem item : this.tabs.getItems()) {
            ((AsyncTabItem)item).setProcessed(false);
            item.setEnabled(false);
        }
    }

    @Override
    public void emptySelection() {
        this.fillData(new ArrayList());
    }

    @Override
    public void close() {
        this.fillData(this.selectedNodes);
    }

    @Override
    public void fillData(Object selectedItem) {
        this.clear();
        this.properties = null;
        this.types = null;
        this.mixin = null;
        this.ok.setEnabled(false);
        if (selectedItem != null) {
            if (selectedItem instanceof GWTJahiaNode) {
                this.selectedNodes = new ArrayList<GWTJahiaNode>();
                this.selectedNodes.add((GWTJahiaNode)selectedItem);
            } else {
                this.selectedNodes = (List)selectedItem;
            }
            StringBuilder heading = new StringBuilder();
            if (this.selectedNodes.size() == 0) {
                heading.append("&nbsp;");
            } else {
                heading.append("");
            }
            for (GWTJahiaNode node : this.selectedNodes) {
                if (heading.length() + node.getName().length() < 100) {
                    heading.append(node.getName()).append(",");
                    continue;
                }
                heading.append("... ");
                break;
            }
            if (this.selectedNodes.size() > 0) {
                heading.deleteCharAt(heading.length() - 1);
            }
            this.m_component.setHeadingHtml(heading.toString());
            if (this.selectedNodes.size() == 1) {
                final GWTJahiaNode node = this.selectedNodes.get(0);
                this.service.initializeEditEngine(node.getPath(), false, (AsyncCallback<GWTJahiaEditEngineInitBean>)new BaseAsyncCallback<GWTJahiaEditEngineInitBean>(){

                    public void onSuccess(GWTJahiaEditEngineInitBean result) {
                        if (ContentDetails.this.selectedNodes == null || !ContentDetails.this.selectedNodes.contains(result.getNode())) {
                            return;
                        }
                        ContentDetails.this.types = result.getNodeTypes();
                        ContentDetails.this.properties = result.getProperties();
                        ContentDetails.this.language = result.getCurrentLocale();
                        ContentDetails.this.defaultLanguageCode = result.getDefaultLanguageCode();
                        ContentDetails.this.mixin = result.getMixin();
                        ContentDetails.this.initializersValues = result.getInitializersValues();
                        ContentDetails.this.defaultValues = result.getDefaultValues();
                        ContentDetails.this.ok.setEnabled(true);
                        ContentDetails.this.acl = result.getAcl();
                        ContentDetails.this.referencesWarnings = result.getReferencesWarnings();
                        if (ContentDetails.this.config.isAllowRootNodeEditing() || node.get("isRootNode") == null) {
                            for (TabItem item : ContentDetails.this.tabs.getItems()) {
                                EditEngineTabItem tabItem = (EditEngineTabItem)item.getData("item");
                                if (!tabItem.getHideForTypes().isEmpty() && result.getNode().isNodeType(tabItem.getHideForTypes()) || !tabItem.getShowForTypes().isEmpty() && !result.getNode().isNodeType(tabItem.getShowForTypes()) || tabItem.getGwtEngineTab().getRequiredPermission() != null && (tabItem.getGwtEngineTab().getRequiredPermission() == null || !PermissionsUtils.isPermitted(tabItem.getGwtEngineTab().getRequiredPermission(), JahiaGWTParameters.getSiteNode()))) continue;
                                item.setEnabled(true);
                            }
                        } else {
                            ContentDetails.this.ok.setEnabled(false);
                        }
                        if (ContentDetails.this.config.isShowWorkInProgress()) {
                            ContentDetails.this.wip.setEnabled(true);
                            ContentDetails.this.wip.setValue(Boolean.valueOf(result.getNode() != null && result.getNode().get("j:workInProgress") != null && (Boolean)result.getNode().get("j:workInProgress") != false));
                        }
                        ContentDetails.this.fillCurrentTab();
                    }
                });
            } else if (this.selectedNodes.size() > 1) {
                ArrayList<String> paths = new ArrayList<String>();
                for (GWTJahiaNode node : this.selectedNodes) {
                    paths.add(node.getPath());
                }
                this.service.initializeEditEngine(paths, false, (AsyncCallback<GWTJahiaEditEngineInitBean>)new BaseAsyncCallback<GWTJahiaEditEngineInitBean>(){

                    public void onSuccess(GWTJahiaEditEngineInitBean result) {
                        ContentDetails.this.types = result.getNodeTypes();
                        ContentDetails.this.properties = result.getProperties();
                        ContentDetails.this.language = result.getCurrentLocale();
                        ContentDetails.this.mixin = result.getMixin();
                        ContentDetails.this.initializersValues = result.getInitializersValues();
                        ContentDetails.this.defaultValues = result.getDefaultValues();
                        ContentDetails.this.ok.setEnabled(true);
                        for (TabItem item : ContentDetails.this.tabs.getItems()) {
                            EditEngineTabItem editItem = (EditEngineTabItem)item.getData("item");
                            if (((EditEngineTabItem)item.getData("item")).isHandleMultipleSelection() && (editItem.getGwtEngineTab().getRequiredPermission() == null || editItem.getGwtEngineTab().getRequiredPermission() != null && PermissionsUtils.isPermitted(editItem.getGwtEngineTab().getRequiredPermission(), JahiaGWTParameters.getSiteNode()))) {
                                item.setEnabled(true);
                            }
                            if (ContentDetails.this.tabs.getSelectedItem().equals(item) || !(editItem instanceof ContentTabItem) || !((ContentTabItem)editItem).isNodeNameFieldDisplayed()) continue;
                            ((ContentTabItem)editItem).getName().setValue((Object)ContentDetails.this.getNodeName());
                        }
                        if (ContentDetails.this.config.isShowWorkInProgress()) {
                            ContentDetails.this.wip.setEnabled(false);
                        }
                        ContentDetails.this.fillCurrentTab();
                    }
                });
            }
        }
    }

    private void fillCurrentTab() {
        TabItem currentTab = this.tabs.getSelectedItem();
        Object currentTabItem = currentTab.getData("item");
        if (currentTabItem instanceof EditEngineTabItem) {
            EditEngineTabItem engineTabItem = (EditEngineTabItem)currentTabItem;
            if (!((AsyncTabItem)currentTab).isProcessed()) {
                engineTabItem.init(this, (AsyncTabItem)currentTab, this.language.getLanguage());
                this.m_component.layout();
            }
        }
    }

    @Override
    public List<GWTJahiaNodeType> getNodeTypes() {
        return this.types;
    }

    @Override
    public List<GWTJahiaNodeType> getMixin() {
        return this.mixin;
    }

    @Override
    public Map<String, GWTChoiceListInitializer> getChoiceListInitializersValues() {
        return this.initializersValues;
    }

    @Override
    public GWTJahiaNode getNode() {
        return this.selectedNodes != null ? this.selectedNodes.get(0) : null;
    }

    @Override
    public List<GWTJahiaNode> getNodes() {
        return this.selectedNodes;
    }

    @Override
    public String getNodeName() {
        return this.getNode().getName();
    }

    @Override
    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    @Override
    public GWTJahiaNodeACL getAcl() {
        return this.acl;
    }

    @Override
    public List<GWTJahiaNode> getSelection() {
        return this.selectedNodes;
    }

    @Override
    public Map<String, Set<String>> getReferencesWarnings() {
        return this.referencesWarnings;
    }

    @Override
    public GWTJahiaNode getTargetNode() {
        return null;
    }

    @Override
    public boolean isExistingNode() {
        return true;
    }

    @Override
    public boolean isMultipleSelection() {
        return this.selectedNodes != null && this.selectedNodes.size() > 1;
    }

    @Override
    public Map<String, GWTJahiaNodeProperty> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, GWTJahiaNodeProperty> getPresetProperties() {
        return new HashMap<String, GWTJahiaNodeProperty>();
    }

    @Override
    public Map<String, Map<String, List<GWTJahiaNodePropertyValue>>> getDefaultValues() {
        return this.defaultValues;
    }

    private void save(List<GWTJahiaNodeProperty> changedProperties, Set<String> removedTypes, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties) {
        final boolean okEnabled = this.ok.isEnabled();
        this.ok.setEnabled(false);
        BaseAsyncCallback callback = new BaseAsyncCallback(){

            @Override
            public void onApplicationFailure(Throwable throwable) {
                String message = throwable.getMessage();
                if (message.contains("Invalid link")) {
                    message = Messages.get("label.error.invalidlink", "Invalid link") + " : " + message.substring(message.indexOf(":") + 1);
                }
                Window.alert((String)(Messages.get("failure.properties.save", "Properties save failed") + "\n\n" + message));
                Log.error((String)"failed", (Throwable)throwable);
                ContentDetails.this.ok.setEnabled(okEnabled);
            }

            public void onSuccess(Object o) {
                ContentDetails.this.ok.setEnabled(okEnabled);
                Info.display((String)Messages.get("label.information", "Information"), (String)Messages.get("saved_prop", "Properties saved\n\n"));
                if (ContentDetails.this.getNodes().contains(ContentDetails.this.linker.getSelectionContext().getMainNode())) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("refreshAll", true);
                    ContentDetails.this.linker.refresh(data);
                } else {
                    ContentDetails.this.linker.refreshTable();
                }
            }
        };
        if (this.isMultipleSelection()) {
            JahiaContentManagementService.App.getInstance().savePropertiesAndACL(this.getNodes(), null, changedI18NProperties, changedProperties, removedTypes, callback);
        } else {
            JahiaContentManagementService.App.getInstance().saveNode(this.getNode(), this.acl, changedI18NProperties, changedProperties, removedTypes, callback);
        }
    }

    private class SaveSelectionListener
    extends SelectionListener<ButtonEvent> {
        public void componentSelected(ButtonEvent event) {
            final ArrayList<GWTJahiaNodeProperty> changedProperties = new ArrayList<GWTJahiaNodeProperty>();
            if (ContentDetails.this.getNode() != null && ContentDetails.this.getNode().isNodeType("jmix:lastPublished")) {
                for (GWTJahiaNodeProperty property : changedProperties) {
                    if (!property.getName().equals("j:workInProgress")) continue;
                    if (ContentDetails.this.workInProgress) {
                        property.setValue(new GWTJahiaNodePropertyValue(Boolean.toString(ContentDetails.this.workInProgress), 6));
                    } else {
                        property.setValue(new GWTJahiaNodePropertyValue((String)null, 6));
                    }
                    return;
                }
            }
            HashSet<String> addedTypes = new HashSet<String>();
            final HashSet<String> removedTypes = new HashSet<String>();
            final HashMap<String, List<GWTJahiaNodeProperty>> changedI18NProperties = new HashMap<String, List<GWTJahiaNodeProperty>>();
            for (TabItem tab : ContentDetails.this.tabs.getItems()) {
                EditEngineTabItem item = (EditEngineTabItem)tab.getData("item");
                if (item instanceof ContentTabItem && ((ContentTabItem)item).isNodeNameFieldDisplayed()) {
                    String nodeName = (String)((ContentTabItem)item).getName().getValue();
                    ContentDetails.this.getNode().setName(nodeName);
                }
                item.doSave(ContentDetails.this.getNode(), changedProperties, changedI18NProperties, addedTypes, removedTypes, null, ContentDetails.this.acl);
            }
            if (ContentDetails.this.config.isShowWorkInProgress()) {
                if (changedI18NProperties.containsKey(ContentDetails.this.language.getLanguage())) {
                    ((List)changedI18NProperties.get(ContentDetails.this.language.getLanguage())).add(new GWTJahiaNodeProperty("j:workInProgress", Boolean.toString(ContentDetails.this.workInProgress), 6));
                } else {
                    changedI18NProperties.put(ContentDetails.this.language.getLanguage(), Arrays.asList(new GWTJahiaNodeProperty("j:workInProgress", Boolean.toString(ContentDetails.this.workInProgress), 6)));
                }
            }
            ContentDetails.this.getNode().getNodeTypes().removeAll(removedTypes);
            ContentDetails.this.getNode().getNodeTypes().addAll(addedTypes);
            EngineValidation e = new EngineValidation(ContentDetails.this, ContentDetails.this.tabs, ContentDetails.this.defaultLanguageCode, changedI18NProperties);
            boolean valid = e.validateData(new EngineValidation.ValidateCallback(){

                @Override
                public void handleValidationResult(EngineValidation.ValidateResult result) {
                    if (result.errorTab != null && !ContentDetails.this.tabs.getSelectedItem().equals(result.errorTab)) {
                        ContentDetails.this.tabs.setSelection(result.errorTab);
                    }
                    if (result.errorField != null) {
                        result.errorField.focus();
                    }
                    if (result.errorTab != null) {
                        result.errorTab.layout();
                    }
                }

                @Override
                public void saveAnyway() {
                    ContentDetails.this.save(changedProperties, removedTypes, changedI18NProperties);
                }

                @Override
                public void close() {
                }
            });
            if (valid) {
                ContentDetails.this.save(changedProperties, removedTypes, changedI18NProperties);
            }
        }
    }
}

