/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.IconButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.ListView;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.button.ToolButton;
import com.extjs.gxt.ui.client.widget.layout.AccordionLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayoutData;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTRepository;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.widget.content.ContentSearchForm;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.content.RepositoryTab;
import org.jahia.ajax.gwt.client.widget.tripanel.LeftComponent;

public class ContentRepositoryTabs
extends LeftComponent {
    private TabPanel m_component;
    private TabItem browseTabITem;
    private TabItem searchTabITem;
    private LayoutContainer browseComponent;
    private ContentSearchForm contentSearchForm;
    private JahiaContentManagementServiceAsync service = JahiaContentManagementService.App.getInstance();
    private List<RepositoryTab> repositories = new ArrayList<RepositoryTab>();
    private ContentPanel savedSearchPanel;
    private ListView<GWTJahiaNode> queryList;
    private boolean tabExpanded;

    public ContentRepositoryTabs(GWTManagerConfiguration config, List<String> selectedPaths) {
        this.m_component = new TabPanel();
        this.m_component.setBodyBorder(false);
        this.m_component.setBorders(false);
        this.browseTabITem = new TabItem(Messages.get("browse.label", "Browse"));
        this.browseTabITem.setId("CRTbrowseTabItem");
        this.searchTabITem = new TabItem(Messages.get("label.search", "Search"));
        this.searchTabITem.setId("CRTsearchTabItem");
        ChangeAccordionListener accordionListener = new ChangeAccordionListener();
        this.browseComponent = new LayoutContainer((Layout)new AccordionLayout());
        this.browseComponent.setScrollMode(Style.Scroll.NONE);
        this.browseComponent.setBorders(true);
        for (GWTRepository repo : config.getRepositories()) {
            final RepositoryTab tab = new RepositoryTab(this, repo, selectedPaths, config);
            this.repositories.add(tab);
            this.browseComponent.add((Widget)tab);
            if (config.getSelectedAccordion() != null && tab.getRepository().getKey().equals(config.getSelectedAccordion()) || config.getSelectedAccordion() == null && this.repositories.size() == 1) {
                tab.expand();
            }
            tab.addListener(Events.Expand, accordionListener);
            tab.getHeader().addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    if (!tab.isExpanded()) {
                        ContentRepositoryTabs.this.tabExpanded = true;
                        tab.refresh(null);
                    }
                }
            });
        }
        this.savedSearchPanel = new ContentPanel((Layout)new FitLayout());
        this.savedSearchPanel.setBodyBorder(false);
        this.savedSearchPanel.setBorders(false);
        this.savedSearchPanel.setScrollMode(Style.Scroll.NONE);
        this.savedSearchPanel.setHeadingHtml(Messages.get("repository.savedSearch.label"));
        this.savedSearchPanel.getHeader().setIcon(StandardIconsProvider.STANDARD_ICONS.savedSearch());
        this.savedSearchPanel.getHeader().setBorders(false);
        this.queryList = new ListView();
        this.queryList.setBorders(false);
        this.queryList.setHeight("92%");
        this.queryList.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        this.queryList.setStore(new ListStore());
        this.queryList.setDisplayProperty("displayName");
        this.savedSearchPanel.add(this.queryList, (LayoutData)new VBoxLayoutData(new Margins(0, 0, 5, 0)));
        this.queryList.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> se) {
                ContentRepositoryTabs.this.getLinker().getTopRightObject().setContent(ContentRepositoryTabs.this.queryList.getSelectionModel().getSelectedItem());
            }
        });
        Menu queryMenu = new Menu();
        final MenuItem removeQuery = new MenuItem(Messages.get("label.remove"), (SelectionListener)new SelectionListener<MenuEvent>(){

            public void componentSelected(MenuEvent event) {
                final GWTJahiaNode item = (GWTJahiaNode)ContentRepositoryTabs.this.queryList.getSelectionModel().getSelectedItem();
                if (item != null) {
                    ArrayList<String> queryNode = new ArrayList<String>();
                    queryNode.add(item.getPath());
                    ContentRepositoryTabs.this.service.deletePaths(queryNode, new BaseAsyncCallback<Object>(){

                        @Override
                        public void onApplicationFailure(Throwable throwable) {
                            Window.alert((String)("Query deletion failed\n\n" + throwable.getLocalizedMessage()));
                        }

                        public void onSuccess(Object o) {
                            ContentRepositoryTabs.this.queryList.getStore().remove((ModelData)item);
                            ContentRepositoryTabs.this.retrieveSavedSearch();
                        }
                    });
                }
            }
        });
        MenuItem renameQuery = new MenuItem(Messages.get("label.rename"), (SelectionListener)new SelectionListener<MenuEvent>(){

            public void componentSelected(MenuEvent event) {
                GWTJahiaNode item = (GWTJahiaNode)ContentRepositoryTabs.this.queryList.getSelectionModel().getSelectedItem();
                if (item != null) {
                    ContentRepositoryTabs.this.renameSearch(item);
                }
            }
        });
        queryMenu.addListener(Events.BeforeShow, (Listener)new Listener<MenuEvent>(){

            public void handleEvent(MenuEvent baseEvent) {
                removeQuery.setEnabled(ContentRepositoryTabs.this.queryList.getSelectionModel().getSelectedItem() != null);
            }
        });
        queryMenu.add((Component)removeQuery);
        queryMenu.add((Component)renameQuery);
        this.queryList.setContextMenu(queryMenu);
        this.savedSearchPanel.getHeader().addTool((Component)new ToolButton("x-tool-refresh", (SelectionListener)new SelectionListener<IconButtonEvent>(){

            public void componentSelected(IconButtonEvent event) {
                ContentRepositoryTabs.this.retrieveSavedSearch();
            }
        }));
        this.browseComponent.add((Widget)this.savedSearchPanel);
        this.browseTabITem.setLayout((Layout)new FitLayout());
        this.browseTabITem.add((Widget)this.browseComponent);
        this.m_component.add(this.browseTabITem);
        this.contentSearchForm = new ContentSearchForm(config);
        this.searchTabITem.setLayout((Layout)new FitLayout());
        this.searchTabITem.setIcon(ToolbarIconProvider.getInstance().getIcon("search"));
        this.searchTabITem.add((Widget)this.contentSearchForm);
        this.m_component.add(this.searchTabITem);
        this.savedSearchPanel.addListener(Events.Expand, accordionListener);
        this.m_component.addListener(Events.ContextMenu, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent be) {
                ContentRepositoryTabs.this.getLinker().getSelectionContext().refresh(2);
            }
        });
    }

    private void renameSearch(GWTJahiaNode selection) {
        if (selection != null) {
            if (selection.isLocked().booleanValue()) {
                Window.alert((String)(selection.getName() + " is locked"));
                return;
            }
            String newName = Window.prompt((String)("Enter the new name for " + (selection.isFile() != false ? "file " : "folder ") + selection.getName()), (String)selection.getName());
            if (newName != null && newName.length() > 0 && !newName.equals(selection.getName())) {
                this.service.rename(selection.getPath(), newName, (AsyncCallback<GWTJahiaNode>)new BaseAsyncCallback<GWTJahiaNode>(){

                    @Override
                    public void onApplicationFailure(Throwable throwable) {
                        Window.alert((String)("Rename failed\n\n" + throwable.getLocalizedMessage()));
                    }

                    public void onSuccess(GWTJahiaNode o) {
                        ContentRepositoryTabs.this.retrieveSavedSearch();
                    }
                });
            }
        }
    }

    @Override
    public void initWithLinker(ManagerLinker linker) {
        super.initWithLinker(linker);
        for (RepositoryTab tab : this.repositories) {
            tab.init();
        }
        this.contentSearchForm.initWithLinker(linker);
    }

    @Override
    public void openAndSelectItem(Object item) {
        if (item != null) {
            for (RepositoryTab tab : this.repositories) {
                tab.openAndSelectItem(item);
            }
        }
    }

    @Override
    public void refresh(Map<String, Object> data) {
        for (RepositoryTab tab : this.repositories) {
            tab.refresh(data);
        }
    }

    private void retrieveSavedSearch() {
        this.queryList.getStore().removeAll();
        this.service.getSavedSearch((AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

            public void onSuccess(List<GWTJahiaNode> gwtJahiaNodes) {
                ContentRepositoryTabs.this.queryList.getStore().add(gwtJahiaNodes);
            }
        });
    }

    @Override
    public Object getSelectedItem() {
        if (this.savedSearchPanel.isExpanded()) {
            return this.queryList.getSelectionModel().getSelectedItem();
        }
        for (RepositoryTab tab : this.repositories) {
            if (!tab.isExpanded()) continue;
            return tab.getSelectedItem();
        }
        return null;
    }

    public void expandTab(RepositoryTab tab) {
        if (!this.tabExpanded) {
            tab.expand();
            this.tabExpanded = true;
        }
    }

    @Override
    public Component getComponent() {
        return this.m_component;
    }

    private class ChangeAccordionListener<T extends ComponentEvent>
    implements Listener<T> {
        private ChangeAccordionListener() {
        }

        public void handleEvent(T t) {
            if (ContentRepositoryTabs.this.savedSearchPanel.isExpanded()) {
                ContentRepositoryTabs.this.retrieveSavedSearch();
            }
            ContentRepositoryTabs.this.getLinker().onTreeItemSelected();
        }
    }
}

