/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.BasePagingLoadConfig;
import com.extjs.gxt.ui.client.data.BasePagingLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.PagingLoader;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.CheckBoxGroup;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.GWTJahiaSearchQuery;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.ExistingFileException;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.content.JCRClientUtils;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.content.AbstractView;
import org.jahia.ajax.gwt.client.widget.content.ContentPickerField;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.form.CalendarField;

public class ContentSearchForm
extends ContentPanel
implements AbstractView.ContentSource {
    private TextField<String> searchField;
    private ContentPickerField pagePickerField;
    private ComboBox<GWTJahiaLanguage> langPickerField;
    private CalendarField startDateField;
    private CalendarField endDateField;
    private ComboBox<ModelData> timesField;
    private SimpleComboBox<String> itemPerPage;
    private RadioGroup dateTypeField;
    private CheckBox inNameField;
    private CheckBox inTagField;
    private CheckBox inContentField;
    private CheckBox inFileField;
    private CheckBox inMetadataField;
    private ManagerLinker linker;
    private GWTManagerConfiguration config;

    public ContentSearchForm(GWTManagerConfiguration config) {
        this.config = config;
        this.setLayout((Layout)new RowLayout(Style.Orientation.VERTICAL));
        this.setWidth("100%");
        this.setHeight("100%");
        FormPanel searchForm = new FormPanel();
        searchForm.setHeaderVisible(false);
        searchForm.setBorders(false);
        searchForm.setBodyBorder(false);
        this.searchField = new TextField();
        this.searchField.setFieldLabel(Messages.get("search.label"));
        this.searchField.addKeyListener(new KeyListener(){

            public void componentKeyPress(ComponentEvent event) {
                if (event.getKeyCode() == 13) {
                    ContentSearchForm.this.doSearch();
                }
            }
        });
        Button ok = new Button("", (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent e) {
                ContentSearchForm.this.doSearch();
            }
        });
        ok.setIcon(StandardIconsProvider.STANDARD_ICONS.search());
        ok.addStyleName("button-ok");
        Button save = new Button("", (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent e) {
                ContentSearchForm.this.saveSearch();
            }
        });
        save.addStyleName("button-save");
        save.setIcon(StandardIconsProvider.STANDARD_ICONS.savedSearch());
        save.setToolTip(Messages.get("saveSearch.label"));
        HorizontalPanel mainField = new HorizontalPanel();
        mainField.setSpacing(2);
        LayoutContainer formLayoutContainer = new LayoutContainer();
        FormLayout flayout = new FormLayout();
        flayout.setLabelWidth(50);
        formLayoutContainer.setLayout((Layout)flayout);
        formLayoutContainer.add(this.searchField);
        mainField.add((Widget)formLayoutContainer);
        mainField.add((Widget)ok);
        mainField.add((Widget)save);
        this.add((Widget)mainField, (LayoutData)new RowData(1.0, -1.0, new Margins(0)));
        FieldSet fieldSet = new FieldSet();
        fieldSet.setHeadingHtml(Messages.get("label.detailed", "Advanced"));
        FormLayout layout = new FormLayout();
        layout.setLabelWidth(70);
        fieldSet.setLayout((Layout)layout);
        fieldSet.setCollapsible(false);
        this.pagePickerField = this.createPageSelectorField();
        fieldSet.add((Widget)this.pagePickerField);
        if (!config.isDisplaySearchInPage()) {
            this.pagePickerField.hide();
        }
        this.langPickerField = this.createLanguageSelectorField();
        fieldSet.add(this.langPickerField);
        searchForm.add((Widget)fieldSet);
        CheckBoxGroup scopeCheckGroup = new CheckBoxGroup();
        scopeCheckGroup.setOrientation(Style.Orientation.VERTICAL);
        scopeCheckGroup.setFieldLabel(Messages.get("label_searchScope", "Search scope"));
        this.inNameField = this.createNameField();
        scopeCheckGroup.add((Field)this.inNameField);
        this.inTagField = this.createTagField();
        scopeCheckGroup.add((Field)this.inTagField);
        this.inMetadataField = this.createMetadataField();
        scopeCheckGroup.add((Field)this.inMetadataField);
        this.inMetadataField.hide();
        this.inContentField = this.createContentField();
        scopeCheckGroup.add((Field)this.inContentField);
        this.inFileField = this.createFileField();
        scopeCheckGroup.add((Field)this.inFileField);
        fieldSet.add((Widget)scopeCheckGroup, (LayoutData)new FormData("-20"));
        if (config.isDisplaySearchInDateMeta()) {
            Radio radio = new Radio();
            radio.setBoxLabel(Messages.get("label.modification", "modification"));
            radio.setValueAttribute("1");
            radio.setValue(Boolean.valueOf(true));
            Radio radio2 = new Radio();
            radio2.setBoxLabel(Messages.get("label.creation", "creation"));
            radio2.setValueAttribute("2");
            Radio radio3 = new Radio();
            radio3.setBoxLabel(Messages.get("label.publication", "publication"));
            radio3.setValueAttribute("3");
            this.dateTypeField = new RadioGroup();
            this.dateTypeField.setOrientation(Style.Orientation.VERTICAL);
            this.dateTypeField.setFieldLabel(Messages.get("label.dateType", "According date of"));
            this.dateTypeField.add(radio);
            this.dateTypeField.add(radio2);
            this.dateTypeField.add(radio3);
            fieldSet.add((Widget)this.dateTypeField);
            this.startDateField = new CalendarField("dd.MM.yyyy", false, false, null, false, null){

                protected void onClick(ComponentEvent ce) {
                    ContentSearchForm.this.timesField.clearSelections();
                    super.onClick(ce);
                }
            };
            this.startDateField.setFieldLabel(Messages.get("label.startDate", "Start Date"));
            this.endDateField = new CalendarField("dd.MM.yyyy", false, false, null, false, null){

                protected void onClick(ComponentEvent ce) {
                    ContentSearchForm.this.timesField.clearSelections();
                    super.onClick(ce);
                }
            };
            this.endDateField.setFieldLabel(Messages.get("label.endDate", "End Date"));
            fieldSet.add((Widget)this.startDateField);
            fieldSet.add((Widget)this.endDateField);
            String[] timesValues = new String[]{"1day,1", "1week,7", "2weeks,14", "1month,30", "3months,90", "6months,180", "1year,365"};
            ListStore times = new ListStore();
            for (String timesValue : timesValues) {
                String[] value = timesValue.split(",");
                BaseModelData d = new BaseModelData();
                d.set("key", (Object)value[1]);
                d.set("title", (Object)Messages.get("label." + value[0], value[0]));
                times.add((ModelData)d);
            }
            this.timesField = new ComboBox<ModelData>(){

                protected void onClick(ComponentEvent ce) {
                    ContentSearchForm.this.startDateField.clear();
                    ContentSearchForm.this.endDateField.clear();
                    this.clear();
                    super.onClick(ce);
                }
            };
            this.timesField.setDisplayField("title");
            this.timesField.setValueField("key");
            this.timesField.setStore(times);
            this.timesField.setFieldLabel(Messages.get("label.timeRange", "Time range"));
            fieldSet.add(this.timesField);
            this.itemPerPage = new SimpleComboBox<String>(){

                protected void onClick(ComponentEvent ce) {
                    this.clear();
                    super.onClick(ce);
                }
            };
            this.itemPerPage.add(Arrays.asList("20", "50", "100", "500", Messages.get("label.all", "All")));
            this.itemPerPage.setSimpleValue((Object)"50");
            this.itemPerPage.setFieldLabel(Messages.get("label.itemPerPage", "items per page"));
            fieldSet.add(this.itemPerPage);
        }
        this.setWidth("100%");
        this.setFrame(true);
        this.setCollapsible(false);
        this.setBodyBorder(false);
        this.setHeaderVisible(false);
        this.getHeader().setBorders(false);
        this.add((Widget)searchForm, (LayoutData)new RowData(1.0, 1.0, new Margins(0, 0, 20, 0)));
    }

    public void initWithLinker(ManagerLinker linker) {
        this.linker = linker;
    }

    private ContentPickerField createPageSelectorField() {
        ContentPickerField field = new ContentPickerField(null, null, null, null, "pagepicker", false);
        field.setFieldLabel(Messages.get("label.pagePicker", "Pages"));
        return field;
    }

    private CheckBox createNameField() {
        CheckBox field = new CheckBox();
        field.setFieldLabel(Messages.get("label.name", "Name & Metadata"));
        field.setBoxLabel(field.getFieldLabel());
        field.setName("name");
        field.setValue(Boolean.valueOf(true));
        return field;
    }

    private CheckBox createTagField() {
        CheckBox field = new CheckBox();
        field.setFieldLabel(Messages.get("label.tags", "Tags"));
        field.setBoxLabel(field.getFieldLabel());
        field.setName("tag");
        field.setValue(Boolean.valueOf(true));
        if (!this.config.isDisplaySearchInTag()) {
            field.hide();
        }
        return field;
    }

    private CheckBox createMetadataField() {
        CheckBox field = new CheckBox();
        field.setFieldLabel(Messages.get("label.metadata", "Metadata"));
        field.setBoxLabel(field.getFieldLabel());
        field.setName("metadata");
        field.setValue(Boolean.valueOf(true));
        field.hide();
        return field;
    }

    private CheckBox createContentField() {
        CheckBox field = new CheckBox();
        field.setFieldLabel(Messages.get("label.content", "Content"));
        field.setBoxLabel(field.getFieldLabel());
        field.setName("content");
        field.setValue(Boolean.valueOf(this.config.isSearchInContent()));
        if (!this.config.isDisplaySearchInContent()) {
            field.hide();
        }
        return field;
    }

    private CheckBox createFileField() {
        CheckBox field = new CheckBox();
        field.setFieldLabel(Messages.get("fileMenu.label", "File"));
        field.setBoxLabel(field.getFieldLabel());
        field.setName("file");
        field.setValue(Boolean.valueOf(this.config.isSearchInFile()));
        if (!this.config.isDisplaySearchInFile()) {
            field.hide();
        }
        return field;
    }

    private ComboBox<GWTJahiaLanguage> createLanguageSelectorField() {
        ComboBox combo = new ComboBox();
        combo.setFieldLabel(Messages.get("label.language", "Language"));
        combo.setAllowBlank(true);
        combo.setStore(new ListStore());
        combo.setDisplayField("displayName");
        combo.setTemplate(ContentSearchForm.getLangSwitchingTemplate());
        combo.setTypeAhead(true);
        combo.setTriggerAction(ComboBox.TriggerAction.ALL);
        combo.setForceSelection(true);
        combo.getStore().removeAll();
        combo.getStore().add(JahiaGWTParameters.getSiteLanguages());
        return combo;
    }

    public void doSearch() {
        this.linker.getTopRightObject().getComponent().mask(Messages.get("label.searching", "Searching ..."), "x-mask-loading");
        final GWTJahiaSearchQuery gwtJahiaSearchQuery = this.getCurrentQuery();
        if (gwtJahiaSearchQuery.getQuery() != null || this.endDateField != null && this.endDateField.getValue() != null || this.startDateField != null && this.startDateField.getValue() != null || this.timesField != null && this.timesField.getValue() != null) {
            Log.debug((String)((String)this.searchField.getValue() + "," + this.pagePickerField.getValue() + "," + this.langPickerField.getValue() + "," + this.inNameField.getValue() + "," + this.inTagField.getValue()));
            RpcProxy<PagingLoadResult<GWTJahiaNode>> privateProxy = new RpcProxy<PagingLoadResult<GWTJahiaNode>>(){

                protected void load(Object loadConfig, AsyncCallback<PagingLoadResult<GWTJahiaNode>> pagingLoadResultAsyncCallback) {
                    int limit = -1;
                    int offset = -1;
                    if (loadConfig instanceof BasePagingLoadConfig) {
                        BasePagingLoadConfig pConf = (BasePagingLoadConfig)loadConfig;
                        limit = pConf.getLimit();
                        offset = pConf.getOffset();
                    }
                    JahiaContentManagementService.App.getInstance().search(gwtJahiaSearchQuery, limit, offset, ContentSearchForm.this.config.isShowOnlyNodesWithTemplates(), pagingLoadResultAsyncCallback);
                }
            };
            BasePagingLoader<PagingLoadResult<GWTJahiaNode>> loader = new BasePagingLoader<PagingLoadResult<GWTJahiaNode>>((DataProxy)privateProxy){

                protected void onLoadSuccess(Object loadConfig, PagingLoadResult<GWTJahiaNode> result) {
                    if (result.getData().size() == 0) {
                        Window.alert((String)Messages.get("label.noResult", "No result"));
                    }
                    ContentSearchForm.this.linker.getTopRightObject().setProcessedContent(result.getData(), ContentSearchForm.this);
                    ContentSearchForm.this.linker.loaded();
                    ContentSearchForm.this.linker.getTopRightObject().getComponent().unmask();
                    super.onLoadSuccess(loadConfig, result);
                }

                protected void onLoadFailure(Object loadConfig, Throwable t) {
                    Log.debug((String)"error while searching nodes due to:", (Throwable)t);
                    ContentSearchForm.this.linker.getTopRightObject().setProcessedContent(null, ContentSearchForm.this);
                    ContentSearchForm.this.linker.loaded();
                    ContentSearchForm.this.linker.getTopRightObject().getComponent().unmask();
                    super.onLoadFailure(loadConfig, t);
                }
            };
            int limit = this.itemPerPage != null && this.itemPerPage.getValue() != null ? (Messages.get("label.all", "All").equals(((SimpleComboValue)this.itemPerPage.getValue()).getValue()) ? 100000 : Integer.parseInt((String)((SimpleComboValue)this.itemPerPage.getValue()).getValue())) : 50;
            BasePagingLoadConfig loadConfig = new BasePagingLoadConfig(0, limit);
            loader.load((Object)loadConfig);
            this.linker.getTopRightObject().getToolBar().setPageSize(limit);
            this.linker.getTopRightObject().getToolBar().bind((PagingLoader)loader);
            this.linker.getTopRightObject().getToolBar().enable();
        } else {
            Window.alert((String)Messages.get("label.queryEmpty", "Query empty"));
        }
    }

    @Override
    public void refreshTable() {
        this.doSearch();
    }

    private GWTJahiaSearchQuery getCurrentQuery() {
        GWTJahiaSearchQuery gwtJahiaSearchQuery = new GWTJahiaSearchQuery();
        gwtJahiaSearchQuery.setQuery((String)this.searchField.getValue());
        gwtJahiaSearchQuery.setPages((List<GWTJahiaNode>)this.pagePickerField.getValue());
        gwtJahiaSearchQuery.setLanguage((GWTJahiaLanguage)this.langPickerField.getValue());
        gwtJahiaSearchQuery.setInName(this.inNameField.getValue());
        gwtJahiaSearchQuery.setInTags(this.inTagField.getValue());
        gwtJahiaSearchQuery.setInContents(this.inContentField.getValue());
        gwtJahiaSearchQuery.setInFiles(this.inFileField.getValue());
        gwtJahiaSearchQuery.setInMetadatas(this.inMetadataField.getValue());
        gwtJahiaSearchQuery.setFilters(this.config.getFilters());
        gwtJahiaSearchQuery.setNodeTypes(this.config.getNodeTypes());
        gwtJahiaSearchQuery.setFolderTypes(this.config.getFolderTypes());
        gwtJahiaSearchQuery.setOriginSiteUuid(JahiaGWTParameters.getSiteUUID());
        if (this.endDateField != null && this.endDateField.getValue() != null || this.startDateField != null && this.startDateField.getValue() != null || this.timesField != null && this.timesField.getValue() != null) {
            Date startDate = (Date)this.startDateField.getValue();
            Date endDate = null;
            if (this.timesField.getValue() != null) {
                gwtJahiaSearchQuery.setTimeInDays((String)this.timesField.getValue().get("key"));
                endDate = new Date();
            }
            if (endDate == null) {
                endDate = (Date)this.endDateField.getValue();
            }
            switch (Integer.parseInt(this.dateTypeField.getValue().getValueAttribute())) {
                case 1: {
                    gwtJahiaSearchQuery.setStartEditionDate(startDate);
                    gwtJahiaSearchQuery.setEndEditionDate(endDate);
                    break;
                }
                case 2: {
                    gwtJahiaSearchQuery.setStartCreationDate(startDate);
                    gwtJahiaSearchQuery.setEndCreationDate(endDate);
                    break;
                }
                case 3: {
                    gwtJahiaSearchQuery.setStartPublicationDate(startDate);
                    gwtJahiaSearchQuery.setEndPublicationDate(endDate);
                }
            }
        }
        if (this.config.isSearchInCurrentSiteOnly()) {
            gwtJahiaSearchQuery.setSites(Arrays.asList(JahiaGWTParameters.getSiteKey()));
        }
        if (this.config.getSearchBasePath() != null) {
            gwtJahiaSearchQuery.setBasePath(this.config.getSearchBasePath());
        }
        return gwtJahiaSearchQuery;
    }

    public void saveSearch() {
        String name;
        GWTJahiaSearchQuery query = this.getCurrentQuery();
        if (query != null && query.getQuery().length() > 0 && (name = Window.prompt((String)Messages.get("saveSearchName.label", "Please enter a name for this search"), (String)JCRClientUtils.cleanUpFilename(query.getQuery()))) != null && name.length() > 0) {
            name = JCRClientUtils.cleanUpFilename(name);
            JahiaContentManagementServiceAsync service = JahiaContentManagementService.App.getInstance();
            service.saveSearch(query, null, name, false, new BaseAsyncCallback<GWTJahiaNode>(){

                public void onSuccess(GWTJahiaNode o) {
                    Log.debug((String)"saved.");
                }

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    if (throwable instanceof ExistingFileException) {
                        Window.alert((String)Messages.get("fm_inUseSaveSearch", "The entered name is already in use."));
                    } else {
                        Log.error((String)"error", (Throwable)throwable);
                    }
                }
            });
        }
    }

    private static native String getLangSwitchingTemplate();
}

