/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.EventType;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.widget.content.AbstractView;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.content.TableView;
import org.jahia.ajax.gwt.client.widget.content.ThumbView;
import org.jahia.ajax.gwt.client.widget.tripanel.TopRightComponent;

public class ContentViews
extends TopRightComponent {
    private TableView tableView;
    private ThumbView thumbView;
    private ThumbView detailedThumbView;
    private ContentPanel m_component;
    private AbstractView current;
    private GWTManagerConfiguration configuration;

    public ContentViews(GWTManagerConfiguration config) {
        this.configuration = config;
        this.tableView = new TableView(config);
        this.thumbView = new ThumbView(config, false);
        this.detailedThumbView = new ThumbView(config, true);
        this.m_component = new ContentPanel((Layout)new FitLayout());
        this.m_component.setBorders(false);
        this.current = "list".equals(config.getDefaultView()) ? this.tableView : ("thumbs".equals(config.getDefaultView()) ? this.thumbView : ("detailed".equals(config.getDefaultView()) ? this.detailedThumbView : this.tableView));
        this.m_component.setBottomComponent((Component)this.getToolBar());
        this.getToolBar().disable();
        this.m_component.add((Widget)this.current.getComponent());
        this.m_component.addListener(Events.ContextMenu, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent be) {
                ContentViews.this.getLinker().getSelectionContext().refresh(1);
            }
        });
    }

    public void setBottomComponent(Component bottomComponent) {
        this.m_component.setBottomComponent(bottomComponent);
    }

    public void switchToListView() {
        this.switchToView(this.tableView);
    }

    public void switchToThumbView() {
        this.switchToView(this.thumbView);
    }

    public void switchToDetailedThumbView() {
        this.switchToView(this.detailedThumbView);
    }

    public void switchToView(AbstractView newView) {
        if (this.current != newView) {
            List<GWTJahiaNode> hiddenSelection = this.current.getHiddenSelection();
            List<GWTJahiaNode> visibleSelection = this.current.getVisibleSelection();
            this.clearTable();
            this.m_component.removeAll();
            this.current = newView;
            this.m_component.add((Widget)this.current.getComponent());
            this.m_component.layout();
            this.refresh();
            newView.setHiddenSelection(hiddenSelection);
            newView.setVisibleSelection(visibleSelection);
        }
    }

    public void setSelectionMode(Style.SelectionMode mode) {
        this.tableView.getSelectionModel().setSelectionMode(mode);
        this.thumbView.getSelectionModel().setSelectionMode(mode);
        this.detailedThumbView.getSelectionModel().setSelectionMode(mode);
    }

    public void addSelectionListener(EventType eventType, Listener listener) {
        this.tableView.getSelectionModel().addListener(eventType, listener);
        this.thumbView.getSelectionModel().addListener(eventType, listener);
        this.detailedThumbView.getSelectionModel().addListener(eventType, listener);
    }

    @Override
    public void initWithLinker(ManagerLinker linker) {
        super.initWithLinker(linker);
        this.tableView.initWithLinker(linker);
        this.thumbView.initWithLinker(linker);
        this.detailedThumbView.initWithLinker(linker);
    }

    @Override
    public void setContent(Object root) {
        if (this.current != null) {
            this.current.setContent(root);
        }
    }

    @Override
    public void setProcessedContent(Object content, AbstractView.ContentSource source) {
        if (this.current != null) {
            this.current.setProcessedContent(content, source);
        }
    }

    @Override
    public void clearTable() {
        if (this.current != null) {
            this.current.clearTable();
        }
    }

    @Override
    public List<GWTJahiaNode> getSelection() {
        if (this.current != null) {
            return this.current.getSelection();
        }
        return null;
    }

    @Override
    public List<GWTJahiaNode> getHiddenSelection() {
        if (this.current != null) {
            return this.current.getHiddenSelection();
        }
        return null;
    }

    @Override
    public void selectNodes(List<GWTJahiaNode> nodes) {
        if (this.current != null) {
            this.current.selectNodes(nodes);
        }
    }

    @Override
    public void refresh() {
        if (this.current != null) {
            this.current.refresh();
        }
    }

    @Override
    public Component getComponent() {
        return this.m_component;
    }

    @Override
    public void clearSelection() {
        super.clearSelection();
        this.tableView.clearSelection();
        this.thumbView.clearSelection();
    }

    public AbstractView getCurrentView() {
        return this.current;
    }
}

