/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.ListViewEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Slider;
import com.extjs.gxt.ui.client.widget.button.ToggleButton;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.StoreFilterField;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTColumn;
import org.jahia.ajax.gwt.client.data.toolbar.GWTManagerConfiguration;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.content.actions.ContentActions;
import org.jahia.ajax.gwt.client.widget.content.AbstractView;
import org.jahia.ajax.gwt.client.widget.content.ImagePopup;
import org.jahia.ajax.gwt.client.widget.content.PickedContentView;
import org.jahia.ajax.gwt.client.widget.content.ThumbsListView;
import org.jahia.ajax.gwt.client.widget.tripanel.BottomRightComponent;

public class ThumbView
extends AbstractView {
    private ContentPanel m_component = new ContentPanel((Layout)new FitLayout());
    private ThumbsListView view;
    private ComboBox<ModelData> sort;
    private ToggleButton sortOrder;

    public ThumbView(final GWTManagerConfiguration config, boolean detailed) {
        super(config);
        this.m_component.setHeaderVisible(false);
        this.m_component.setScrollMode(Style.Scroll.AUTO);
        this.m_component.setId("images-view");
        this.m_component.setBorders(true);
        this.m_component.setBodyBorder(false);
        if (GXT.isIE) {
            this.m_component.setHeight(400);
        }
        StoreFilterField<GWTJahiaNode> field = new StoreFilterField<GWTJahiaNode>(){

            protected boolean doSelect(Store<GWTJahiaNode> store, GWTJahiaNode parent, GWTJahiaNode record, String property, String filter) {
                String name = record.getName().toLowerCase();
                return name.indexOf(filter.toLowerCase()) != -1;
            }

            protected void onFilter() {
                super.onFilter();
            }
        };
        field.setWidth(150);
        field.bind((Store)this.store);
        ToolBar bar = new ToolBar();
        bar.add((Component)new LabelToolItem(Messages.get("thumbFilter.label")));
        bar.add((Component)field);
        bar.add((Component)new SeparatorToolItem());
        bar.add((Component)new LabelToolItem(Messages.get("thumbSort.label")));
        ListStore sorts = new ListStore();
        for (GWTColumn column : config.getTableColumns()) {
            if (!column.isSortable()) continue;
            BaseModelData d = new BaseModelData();
            d.set("key", (Object)column.getKey());
            d.set("title", (Object)column.getTitle());
            sorts.add((ModelData)d);
        }
        this.sort = new ComboBox();
        this.sort.setDisplayField("title");
        this.sort.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.sort.setEditable(false);
        this.sort.setForceSelection(true);
        this.sort.setStore(sorts);
        this.sort.setValue(sorts.getAt(0));
        this.sort.addListener(Events.SelectionChange, (Listener)new Listener<SelectionChangedEvent>(){

            public void handleEvent(SelectionChangedEvent be) {
                ThumbView.this.sort();
            }
        });
        this.sortOrder = new ToggleButton(Messages.get("invertSort.label"));
        this.sortOrder.addListener(Events.Select, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent componentEvent) {
                ThumbView.this.sort();
            }
        });
        bar.add(this.sort);
        bar.add((Component)this.sortOrder);
        bar.add((Component)new FillToolItem());
        final Slider slider = new Slider();
        slider.setMinValue(32);
        slider.setMaxValue(150);
        slider.setValue(100);
        slider.setWidth(50);
        slider.addListener(Events.Change, (Listener)new Listener<ComponentEvent>(){

            public void handleEvent(ComponentEvent be) {
                ThumbView.this.view.setSize(slider.getValue());
            }
        });
        bar.add((Component)slider);
        this.m_component.setTopComponent((Component)bar);
        this.view = new ThumbsListView(detailed);
        this.view.setStore(this.store);
        this.selectionModel = this.view.getSelectionModel();
        this.view.addListener(Events.DoubleClick, (Listener)new Listener<ListViewEvent>(){

            public void handleEvent(ListViewEvent event) {
                List selection = (List)ThumbView.this.getLinker().getTableSelection();
                if (selection != null && selection.size() > 0) {
                    GWTJahiaNode selected = (GWTJahiaNode)selection.get(0);
                    BottomRightComponent buttonBar = ThumbView.this.getLinker().getBottomRightObject();
                    if (buttonBar instanceof PickedContentView) {
                        ((PickedContentView)buttonBar).setSelection(selection);
                        ((PickedContentView)buttonBar).getSaveButton().fireEvent(Events.Select);
                        return;
                    }
                    if (selected.isFile().booleanValue()) {
                        if (config.isEnableFileDoubleClick()) {
                            if (selected.isDisplayable()) {
                                ImagePopup.popImage(selected, ThumbView.this.getLinker());
                            } else {
                                ContentActions.download(ThumbView.this.getLinker());
                            }
                        }
                    } else if (!config.isHideLeftPanel()) {
                        ThumbView.this.getLinker().onTableItemDoubleClicked(selected);
                    } else {
                        Log.debug((String)"Double click disabled if the hide panel is hidden");
                    }
                }
            }
        });
        this.m_component.add((Widget)this.view);
    }

    private void sort() {
        ModelData col = this.sort.getValue();
        this.store.sort((String)col.get("key"), this.sortOrder.isPressed() ? Style.SortDir.DESC : Style.SortDir.ASC);
    }

    public void setContextMenu(Menu menu) {
        this.view.setContextMenu(menu);
    }

    @Override
    public void setProcessedContent(Object content, AbstractView.ContentSource source) {
        super.setProcessedContent(content, source);
        if (content != null) {
            this.sort();
        }
    }

    @Override
    public Component getComponent() {
        return this.m_component;
    }
}

